/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.structure;

import org.eclipse.dltk.tcl.ast.Substitution;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.structure.TclProcessorUtil;

public class TclModelBuilderUtil {
    protected static boolean isLevel(TclArgument argument) {
        String value = TclProcessorUtil.asString(argument);
        if (value.length() == 0) {
            return false;
        }
        if (value.charAt(0) == '#') {
            return TclModelBuilderUtil.isNumber(value, 1);
        }
        return TclModelBuilderUtil.isNumber(value, 0);
    }

    protected static boolean isNumber(String value, int beginIndex) {
        if (beginIndex < value.length()) {
            int i = beginIndex;
            int len = value.length();
            while (i < len) {
                if (!Character.isDigit(value.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected static boolean isSymbol(TclArgument argument) {
        return !(argument instanceof Substitution);
    }

    protected static String asSymbol(TclArgument nameArg) {
        return TclParseUtil.escapeName(TclProcessorUtil.asString(nameArg));
    }
}

