/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.dialogs;

import java.util.List;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.ui.internal.UIText;
import org.eclipse.egit.gitflow.ui.internal.dialogs.BranchComparator;
import org.eclipse.egit.gitflow.ui.internal.dialogs.BranchListContentProvider;
import org.eclipse.egit.gitflow.ui.internal.dialogs.DecoratedBranchLabelProvider;
import org.eclipse.egit.ui.internal.PreferenceBasedDateFormatter;
import org.eclipse.egit.ui.internal.TreeColumnPatternFilter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.GitDateFormatter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class FilteredBranchesWidget {
    private TreeViewer branchesViewer;
    private final List<Ref> refs;
    private String prefix;
    private GitFlowRepository gfRepo;
    private BranchComparator comparator;
    private GitDateFormatter dateFormatter;

    FilteredBranchesWidget(List<Ref> refs, String prefix, GitFlowRepository gfRepo) {
        this.refs = refs;
        this.prefix = prefix;
        this.gfRepo = gfRepo;
    }

    Control create(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)area);
        area.setLayout((Layout)new GridLayout(1, false));
        FilteredTree tree = new FilteredTree(area, 68354, (PatternFilter)new TreeColumnPatternFilter(), true);
        tree.setQuickSelectionMode(true);
        this.branchesViewer = tree.getViewer();
        this.branchesViewer.getTree().setLinesVisible(false);
        this.branchesViewer.getTree().setHeaderVisible(true);
        this.comparator = new BranchComparator();
        this.branchesViewer.setComparator((ViewerComparator)this.comparator);
        DecoratedBranchLabelProvider nameLabelProvider = new DecoratedBranchLabelProvider(this.gfRepo.getRepository(), this.prefix);
        TreeColumn nameColumn = this.createColumn(UIText.BranchSelectionTree_NameColumn, this.branchesViewer, nameLabelProvider);
        TreeColumn idColumn = this.createColumn(UIText.BranchSelectionTree_IdColumn, this.branchesViewer, new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Ref) {
                    ObjectId objectId = ((Ref)element).getObjectId();
                    if (objectId == null) {
                        return "";
                    }
                    return objectId.abbreviate(7).name();
                }
                return super.getText(element);
            }
        });
        ColumnLabelProvider dateLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Ref) {
                    String name = ((Ref)element).getName().substring("refs/heads/".length());
                    RevCommit revCommit = FilteredBranchesWidget.this.gfRepo.findHead(name);
                    if (revCommit == null) {
                        return "";
                    }
                    return FilteredBranchesWidget.this.getDateFormatter().formatDate(revCommit.getCommitterIdent());
                }
                return super.getText(element);
            }
        };
        TreeColumn dateColumn = this.createColumn(UIText.FilteredBranchesWidget_lastModified, this.branchesViewer, dateLabelProvider);
        this.setSortedColumn(dateColumn, dateLabelProvider);
        TreeColumn msgColumn = this.createColumn(UIText.BranchSelectionTree_MessageColumn, this.branchesViewer, new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Ref) {
                    String name = ((Ref)element).getName().substring("refs/heads/".length());
                    RevCommit revCommit = FilteredBranchesWidget.this.gfRepo.findHead(name);
                    if (revCommit == null) {
                        return "";
                    }
                    return revCommit.getShortMessage();
                }
                return super.getText(element);
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.branchesViewer.getControl());
        this.branchesViewer.setContentProvider((IContentProvider)new BranchListContentProvider());
        this.branchesViewer.setInput(this.refs);
        TreeColumnLayout layout = new TreeColumnLayout();
        nameColumn.pack();
        layout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(0, nameColumn.getWidth()));
        idColumn.pack();
        layout.setColumnData((Widget)idColumn, (ColumnLayoutData)new ColumnWeightData(0, idColumn.getWidth()));
        dateColumn.pack();
        layout.setColumnData((Widget)dateColumn, (ColumnLayoutData)new ColumnWeightData(0, dateColumn.getWidth()));
        layout.setColumnData((Widget)msgColumn, (ColumnLayoutData)new ColumnWeightData(100));
        this.branchesViewer.getTree().getParent().setLayout((Layout)layout);
        this.branchesViewer.addFilter(this.createFilter());
        return area;
    }

    private GitDateFormatter getDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = PreferenceBasedDateFormatter.create();
        }
        return this.dateFormatter;
    }

    private TreeColumn createColumn(String name, TreeViewer treeViewer, final ColumnLabelProvider labelProvider) {
        final TreeColumn column = new TreeColumn(treeViewer.getTree(), 16384);
        column.setAlignment(16384);
        column.setText(name);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteredBranchesWidget.this.setSortedColumn(column, labelProvider);
            }
        });
        TreeViewerColumn treeViewerNameColumn = new TreeViewerColumn(treeViewer, column);
        treeViewerNameColumn.setLabelProvider((CellLabelProvider)labelProvider);
        return column;
    }

    private void setSortedColumn(TreeColumn column, ColumnLabelProvider labelProvider) {
        this.comparator.setColumn(column, labelProvider);
        int dir = this.comparator.getDirection();
        this.branchesViewer.getTree().setSortDirection(dir);
        this.branchesViewer.getTree().setSortColumn(column);
        this.branchesViewer.refresh();
    }

    private ViewerFilter createFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return true;
            }
        };
    }

    List<Ref> getSelection() {
        return ((IStructuredSelection)this.branchesViewer.getSelection()).toList();
    }

    TreeViewer getBranchesList() {
        return this.branchesViewer;
    }
}

