/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.action;

import java.io.IOException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.revision.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.synchronize.compare.LocalNonWorkspaceTypedElement;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCacheFile;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelRepository;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelWorkingFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.internal.ui.synchronize.actions.OpenInCompareAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GitOpenInCompareAction
extends Action {
    private final Action oldAction;
    private final ISynchronizePageConfiguration conf;

    public GitOpenInCompareAction(ISynchronizePageConfiguration configuration, Action oldAction) {
        this.conf = configuration;
        this.oldAction = oldAction;
    }

    public void run() {
        ISelection selection = this.conf.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            boolean reuseEditor = sel.size() == 1;
            for (Object obj : sel) {
                if (obj instanceof GitModelBlob) {
                    this.handleGitObjectComparison((GitModelBlob)((Object)obj), reuseEditor);
                    continue;
                }
                this.oldAction.run();
                break;
            }
        }
    }

    private void handleGitObjectComparison(GitModelBlob obj, boolean reuseEditor) {
        ITypedElement right;
        Object left;
        if (obj instanceof GitModelWorkingFile) {
            IPath location = obj.getLocation();
            if (location == null) {
                return;
            }
            IFile file = ResourceUtil.getFileForLocation((IPath)location, (boolean)false);
            if (file == null) {
                Repository repository = null;
                GitModelObject modelObject = obj;
                while (modelObject != null) {
                    if (modelObject instanceof GitModelRepository) {
                        repository = ((GitModelRepository)modelObject).getRepository();
                        break;
                    }
                    modelObject = modelObject.getParent();
                }
                if (repository == null) {
                    return;
                }
                left = new LocalNonWorkspaceTypedElement(repository, location);
            } else {
                left = SaveableCompareEditorInput.createFileElement((IFile)file);
            }
            right = this.getCachedFileElement(obj);
        } else if (obj instanceof GitModelCacheFile) {
            left = this.getCachedFileElement(obj);
            right = this.getHeadFileElement(obj);
            if (right == null) {
                return;
            }
        } else {
            this.oldAction.run();
            return;
        }
        GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput((ITypedElement)left, right, null);
        IWorkbenchPage page = GitOpenInCompareAction.getWorkbenchPage(this.conf.getSite());
        OpenInCompareAction.openCompareEditor((CompareEditorInput)in, (IWorkbenchPage)page, (boolean)reuseEditor);
    }

    private static IWorkbenchPage getWorkbenchPage(ISynchronizePageSite site) {
        IWorkbenchPage page = null;
        if (site == null || site.getWorkbenchSite() == null) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                page = window.getActivePage();
            }
        } else {
            page = site.getWorkbenchSite().getPage();
        }
        return page;
    }

    private ITypedElement getCachedFileElement(GitModelBlob blob) {
        RepositoryMapping mapping;
        IPath location;
        block3: {
            try {
                location = blob.getLocation();
                mapping = RepositoryMapping.getMapping((IPath)location);
                if (mapping != null) break block3;
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        Repository repo = mapping.getRepository();
        String repoRelativePath = mapping.getRepoRelativePath(location);
        return CompareUtils.getIndexTypedElement(repo, repoRelativePath);
    }

    private ITypedElement getHeadFileElement(GitModelBlob blob) {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IPath)blob.getLocation());
        if (mapping == null) {
            return null;
        }
        Repository repo = mapping.getRepository();
        String gitPath = mapping.getRepoRelativePath(blob.getLocation());
        return CompareUtils.getHeadTypedElement(repo, gitPath);
    }
}

