/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class LoadPackagesIndication
extends CDOServerReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, LoadPackagesIndication.class);
    private String packageUnitID;

    public LoadPackagesIndication(CDOServerProtocol protocol) {
        super(protocol, (short)6);
    }

    protected void indicating(CDODataInput in) throws IOException {
        this.packageUnitID = in.readCDOPackageURI();
        if (TRACER.isEnabled()) {
            TRACER.format("Read packageUnitID: {0}", new Object[]{this.packageUnitID});
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        InternalCDOPackageRegistry packageRegistry = this.getRepository().getPackageRegistry();
        EPackage ePackage = packageRegistry.getEPackage(this.packageUnitID);
        if (ePackage == null) {
            throw new IllegalStateException("Package unit not found: " + this.packageUnitID);
        }
        CDOModelUtil.writePackage((ExtendedDataOutput)out, (EPackage)ePackage, (boolean)true, (EPackage.Registry)packageRegistry);
    }
}

