/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.net4j;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.Request;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.signal.heartbeat.HeartBeatProtocol;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.spi.net4j.ServerProtocolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailoverMonitor
extends Container<AgentProtocol> {
    public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.net4j.failoverMonitors";
    public static final String PROTOCOL_NAME = "failover";
    public static final short SIGNAL_PUBLISH_MASTER = 3;
    private String group;
    private List<AgentProtocol> agents = new ArrayList<AgentProtocol>();
    private AgentProtocol masterAgent;

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.checkInactive();
        this.group = group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        List<AgentProtocol> list = this.agents;
        synchronized (list) {
            return this.agents.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentProtocol[] getElements() {
        List<AgentProtocol> list = this.agents;
        synchronized (list) {
            return this.agents.toArray(new AgentProtocol[this.agents.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentProtocol getMasterAgent() {
        List<AgentProtocol> list = this.agents;
        synchronized (list) {
            return this.masterAgent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAgent(AgentProtocol agent) {
        AgentProtocol newMasterAgent = null;
        AgentProtocol[] newAgents = null;
        List<AgentProtocol> list = this.agents;
        synchronized (list) {
            this.agents.add(agent);
            if (this.agents.size() == 1) {
                this.masterAgent = agent;
            }
            newMasterAgent = this.masterAgent;
            newAgents = this.getElements();
        }
        if (newMasterAgent != null) {
            try {
                this.publishNewMaster(newMasterAgent, newAgents);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
        this.fireElementAddedEvent((Object)agent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterAgent(AgentProtocol agent) {
        AgentProtocol newMasterAgent = null;
        AgentProtocol[] newAgents = null;
        List<AgentProtocol> list = this.agents;
        synchronized (list) {
            if (!this.agents.remove((Object)agent)) {
                return;
            }
            if (this.masterAgent == agent) {
                this.masterAgent = this.agents.isEmpty() ? null : this.electNewMaster(this.agents);
            }
            newMasterAgent = this.masterAgent;
            newAgents = this.getElements();
        }
        if (newMasterAgent != null) {
            this.publishNewMaster(newMasterAgent, newAgents);
        }
        this.fireElementRemovedEvent((Object)agent);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.group, "group");
    }

    protected AgentProtocol electNewMaster(List<AgentProtocol> agents) {
        return agents.iterator().next();
    }

    private void publishNewMaster(final AgentProtocol masterAgent, AgentProtocol[] agents) {
        AgentProtocol[] agentProtocolArray = agents;
        int n = agents.length;
        int n2 = 0;
        while (n2 < n) {
            final AgentProtocol agent = agentProtocolArray[n2];
            try {
                new Request((SignalProtocol)agent, 3){

                    protected void requesting(ExtendedDataOutputStream out) throws Exception {
                        if (agent == masterAgent) {
                            out.writeBoolean(true);
                        } else {
                            out.writeBoolean(false);
                            out.writeString(masterAgent.getConnectorDescription());
                            out.writeString(masterAgent.getRepositoryName());
                        }
                    }
                }.sendAsync();
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
    }

    public static abstract class AbstractServerProtocolFactory
    extends ServerProtocolFactory
    implements Provider {
        private IManagedContainer container;

        protected AbstractServerProtocolFactory(String type) {
            this(type, (IManagedContainer)IPluginContainer.INSTANCE);
        }

        protected AbstractServerProtocolFactory(String type, IManagedContainer container) {
            super(type);
            this.container = container;
        }

        public FailoverMonitor getFailoverMonitor(String group) {
            return (FailoverMonitor)((Object)this.container.getElement(FailoverMonitor.PRODUCT_GROUP, "net4j", group));
        }
    }

    public static class AgentProtocol
    extends HeartBeatProtocol.Server {
        private Provider failoverMonitorProvider;
        private FailoverMonitor failoverMonitor;
        private String connectorDescription;
        private String repositoryName;

        public AgentProtocol(Provider failOverMonitorProvider) {
            super(FailoverMonitor.PROTOCOL_NAME);
            this.failoverMonitorProvider = failOverMonitorProvider;
        }

        public String toString() {
            return String.valueOf(this.connectorDescription) + "/" + this.repositoryName;
        }

        public FailoverMonitor getFailoverMonitor() {
            return this.failoverMonitor;
        }

        public String getConnectorDescription() {
            return this.connectorDescription;
        }

        public String getRepositoryName() {
            return this.repositoryName;
        }

        protected void indicatingStart(ExtendedDataInputStream in) throws IOException {
            String group = in.readString();
            this.connectorDescription = in.readString();
            this.repositoryName = in.readString();
            this.failoverMonitor = this.failoverMonitorProvider.getFailoverMonitor(group);
            if (this.failoverMonitor == null) {
                throw new IllegalStateException("No monitor available for fail-over group " + group);
            }
            this.failoverMonitor.registerAgent(this);
            super.indicatingStart(in);
        }

        protected void doDeactivate() throws Exception {
            try {
                if (this.failoverMonitor != null) {
                    this.failoverMonitor.deregisterAgent(this);
                }
            }
            finally {
                super.doDeactivate();
            }
        }

        public static class Factory
        extends AbstractServerProtocolFactory {
            public Factory(IManagedContainer container) {
                super(FailoverMonitor.PROTOCOL_NAME, container);
            }

            public Factory() {
                super(FailoverMonitor.PROTOCOL_NAME);
            }

            public AgentProtocol create(String description) throws ProductCreationException {
                return new AgentProtocol(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClientProtocol
    extends SignalProtocol<Object> {
        public static final String PROTOCOL_NAME = "failover-client";
        public static final short SIGNAL_QUERY_REPOSITORY_INFO = 1;
        private Provider failoverMonitorProvider;
        private FailoverMonitor failoverMonitor;

        public ClientProtocol(Provider failOverMonitorProvider) {
            super(PROTOCOL_NAME);
            this.failoverMonitorProvider = failOverMonitorProvider;
        }

        protected SignalReactor createSignalReactor(short signalID) {
            switch (signalID) {
                case 1: {
                    return new IndicationWithResponse(this, 1, "QueryRepositoryInfo"){

                        protected void indicating(ExtendedDataInputStream in) throws Exception {
                            String group = in.readString();
                            ClientProtocol.this.failoverMonitor = ClientProtocol.this.failoverMonitorProvider.getFailoverMonitor(group);
                            if (ClientProtocol.this.failoverMonitor == null) {
                                throw new IllegalStateException("No monitor available for fail-over group " + group);
                            }
                        }

                        protected void responding(ExtendedDataOutputStream out) throws Exception {
                            AgentProtocol masterAgent = this.getMasterAgent();
                            out.writeString(masterAgent.getConnectorDescription());
                            out.writeString(masterAgent.getRepositoryName());
                        }

                        protected AgentProtocol getMasterAgent() throws InterruptedException {
                            AgentProtocol masterAgent;
                            while ((masterAgent = ClientProtocol.this.failoverMonitor.getMasterAgent()) == null) {
                                Thread.sleep(100L);
                            }
                            return masterAgent;
                        }
                    };
                }
            }
            return super.createSignalReactor(signalID);
        }

        public static class Factory
        extends AbstractServerProtocolFactory {
            public Factory(IManagedContainer container) {
                super(ClientProtocol.PROTOCOL_NAME, container);
            }

            public Factory() {
                super(ClientProtocol.PROTOCOL_NAME);
            }

            public ClientProtocol create(String description) throws ProductCreationException {
                return new ClientProtocol(this);
            }
        }
    }

    public static class Factory
    extends org.eclipse.net4j.util.factory.Factory {
        public static final String TYPE = "net4j";

        public Factory() {
            super(FailoverMonitor.PRODUCT_GROUP, TYPE);
        }

        public FailoverMonitor create(String description) throws ProductCreationException {
            FailoverMonitor monitor = new FailoverMonitor();
            monitor.setGroup(description);
            return monitor;
        }
    }

    public static interface Provider {
        public FailoverMonitor getFailoverMonitor(String var1);
    }
}

