/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.postprocessor;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ComparisonCanceledException;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.internal.postprocessor.factories.IChangeFactory;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.uml2.internal.UMLCompareMessages;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.compare.uml2.internal.postprocessor.extension.UMLExtensionFactoryRegistry;
import org.eclipse.emf.compare.uml2.internal.postprocessor.util.UMLCompareIterables;
import org.eclipse.emf.compare.uml2.internal.postprocessor.util.UMLCompareUtil;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLPostProcessor
implements IPostProcessor {
    private static final Predicate<Match> ANNOTATION_REFERENCING_PROFILE_DEFINITION = new Predicate<Match>(){
        private Pattern umlNsPattern = Pattern.compile("http://www\\.eclipse\\.org/uml2/.*/UML");

        public boolean apply(Match input) {
            return input.getLeft() instanceof EAnnotation && this.umlNsPattern.matcher(((EAnnotation)input.getLeft()).getSource()).matches();
        }
    };
    private Set<IChangeFactory> uml2ExtensionFactories;

    public void postMatch(Comparison comparison, Monitor monitor) {
        boolean isSameProfileVersion = true;
        Iterator matchesRoot = comparison.getMatches().iterator();
        while (matchesRoot.hasNext() && isSameProfileVersion) {
            Match matchRoot = (Match)matchesRoot.next();
            isSameProfileVersion = this.checkProfileVersion(matchRoot);
            Iterator matches = matchRoot.getAllSubmatches().iterator();
            while (matches.hasNext() && isSameProfileVersion) {
                Match match = (Match)matches.next();
                isSameProfileVersion = this.checkProfileVersion(match);
            }
        }
    }

    private boolean checkProfileVersion(Match match) {
        EObject left = match.getLeft();
        EObject right = match.getRight();
        if (left instanceof ProfileApplication && right != null) {
            Collection annotationsMatches = Collections2.filter((Collection)match.getSubmatches(), ANNOTATION_REFERENCING_PROFILE_DEFINITION);
            for (Match annotationMatch : annotationsMatches) {
                EAnnotation originAnnot = (EAnnotation)annotationMatch.getOrigin();
                EAnnotation leftAnnot = (EAnnotation)annotationMatch.getLeft();
                EAnnotation rightAnnot = (EAnnotation)annotationMatch.getRight();
                if (this.checkProfileVersion(match.getComparison(), (ProfileApplication)left, originAnnot, leftAnnot, rightAnnot)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkProfileVersion(Comparison comparison, ProfileApplication profileApplication, EAnnotation originAnnot, EAnnotation leftAnnot, EAnnotation rightAnnot) {
        boolean missingSomeSide;
        Optional<URI> originURI = Optional.absent();
        boolean originHasProfileDefinition = false;
        if (comparison.isThreeWay()) {
            originURI = UMLCompareIterables.tryFirst(this.getNormalizedURIs(ReferenceUtil.getAsList((EObject)originAnnot, (EStructuralFeature)EcorePackage.Literals.EANNOTATION__REFERENCES)));
            originHasProfileDefinition = MatchUtil.getOriginObject((Comparison)comparison, (EObject)profileApplication) != null;
        }
        Optional<URI> leftURI = UMLCompareIterables.tryFirst(this.getNormalizedURIs(ReferenceUtil.getAsList((EObject)leftAnnot, (EStructuralFeature)EcorePackage.Literals.EANNOTATION__REFERENCES)));
        Optional<URI> rightURI = UMLCompareIterables.tryFirst(this.getNormalizedURIs(ReferenceUtil.getAsList((EObject)rightAnnot, (EStructuralFeature)EcorePackage.Literals.EANNOTATION__REFERENCES)));
        boolean bl = missingSomeSide = leftURI.isPresent() != rightURI.isPresent() || !originURI.isPresent() && originHasProfileDefinition;
        if (missingSomeSide || !leftURI.equals(rightURI) || originURI.isPresent() && !originURI.equals(leftURI)) {
            Package impactedPackage = profileApplication.getApplyingPackage();
            String message = impactedPackage != null ? UMLCompareMessages.getString("profile.definition.changed.on", "<" + impactedPackage.eClass().getName() + "> " + impactedPackage.getName()) : UMLCompareMessages.getString("profile.definition.changed");
            this.addDiagnostic(comparison, (Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.compare.diff.uml", 0, message, new Object[0]));
            return false;
        }
        return true;
    }

    private void addDiagnostic(Comparison comparison, Diagnostic diagnostic) {
        Diagnostic currentDiag = comparison.getDiagnostic();
        if (currentDiag == null) {
            comparison.setDiagnostic((Diagnostic)new BasicDiagnostic("org.eclipse.emf.compare.diff.uml", 0, null, new Object[0]));
        }
        ((BasicDiagnostic)comparison.getDiagnostic()).merge(diagnostic);
    }

    private Collection<URI> getNormalizedURIs(List<Object> eObjects) {
        Function<Object, URI> eObjectToURI = new Function<Object, URI>(){

            public URI apply(Object input) {
                if (input instanceof EObject) {
                    URI uri = EcoreUtil.getURI((EObject)((EObject)input));
                    URIConverter uriConverter = this.getURIConverter((EObject)input);
                    if (uriConverter != null) {
                        uri = uriConverter.normalize(uri);
                    }
                    return uri;
                }
                return null;
            }

            private URIConverter getURIConverter(EObject eObject) {
                ResourceSet resourceSet;
                Resource resource = eObject.eResource();
                if (resource != null && (resourceSet = resource.getResourceSet()) != null) {
                    return resourceSet.getURIConverter();
                }
                return null;
            }
        };
        return Collections2.transform(eObjects, (Function)eObjectToURI);
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
        Map<Class<? extends Diff>, IChangeFactory> mapUml2ExtensionFactories = UMLExtensionFactoryRegistry.createExtensionFactories();
        this.uml2ExtensionFactories = new LinkedHashSet<IChangeFactory>(mapUml2ExtensionFactories.values());
        EList differences = comparison.getDifferences();
        int diffCount = differences.size();
        int i = 0;
        while (i < diffCount) {
            this.applyManagedTypes((Diff)differences.get(i));
            this.reportProgress(monitor, "UMLPostProcessor.monitor.applyManagedTypes", i + 1, diffCount);
            ++i;
        }
        differences = comparison.getDifferences();
        diffCount = differences.size();
        i = 0;
        while (i < diffCount) {
            Class classDiffElement;
            IChangeFactory diffFactory;
            Diff umlDiff = (Diff)differences.get(i);
            if (umlDiff instanceof UMLDiff && (diffFactory = mapUml2ExtensionFactories.get(classDiffElement = umlDiff.eClass().getInstanceClass())) != null) {
                diffFactory.fillRequiredDifferences(comparison, umlDiff);
            }
            this.reportProgress(monitor, "UMLPostProcessor.monitor.fillRequiredDifferences", i + 1, diffCount);
            ++i;
        }
        i = 0;
        while (i < diffCount) {
            Diff diff = (Diff)differences.get(i);
            if (diff instanceof ReferenceChange) {
                ReferenceChange referenceChange = (ReferenceChange)diff;
                this.fillImplicationsWithUMLSubsets(referenceChange);
                this.deleteEnumerationLiteralClassifierChanges(referenceChange);
            }
            this.reportProgress(monitor, "UMLPostProcessor.monitor.fillImplications", i + 1, diffCount);
            ++i;
        }
    }

    private void reportProgress(Monitor monitor, String msgKey, int currentDiffIndex, int diffCount) {
        if (currentDiffIndex % 100 == 1) {
            monitor.subTask(UMLCompareMessages.getString(msgKey, currentDiffIndex, diffCount));
            if (monitor.isCanceled()) {
                throw new ComparisonCanceledException();
            }
        }
    }

    private void applyManagedTypes(Diff element) {
        for (IChangeFactory factory : this.uml2ExtensionFactories) {
            if (!factory.handles(element)) continue;
            Diff extension = factory.create(element);
            if (!extension.getRefinedBy().isEmpty()) {
                Match match = factory.getParentMatch(element);
                if (match == null) continue;
                match.getDifferences().add((Object)extension);
                continue;
            }
            extension = null;
        }
    }

    private void fillImplicationsWithUMLSubsets(ReferenceChange diff) {
        Comparison comparison;
        EReference reference = diff.getReference();
        for (EReference superSet : UMLCompareUtil.getNonUnionSupersetReferences(reference)) {
            comparison = diff.getMatch().getComparison();
            for (Diff superSetDiff : comparison.getDifferences((EObject)superSet)) {
                if (!(superSetDiff instanceof ReferenceChange) || superSetDiff.getSource() != diff.getSource() || ((ReferenceChange)superSetDiff).getReference() != superSet || ((ReferenceChange)superSetDiff).getValue() != diff.getValue() || superSetDiff.getMatch() != diff.getMatch()) continue;
                if (ComparisonUtil.isAddOrSetDiff((Diff)diff) && ComparisonUtil.isAddOrSetDiff((Diff)superSetDiff)) {
                    diff.getImplies().add((Object)superSetDiff);
                    continue;
                }
                if (!ComparisonUtil.isDeleteOrUnsetDiff((Diff)diff) || !ComparisonUtil.isDeleteOrUnsetDiff((Diff)superSetDiff)) continue;
                diff.getImpliedBy().add((Object)superSetDiff);
            }
        }
        if (reference.isContainment() && reference.getEOpposite() != null) {
            for (EReference superSet : UMLCompareUtil.getNonUnionSupersetReferences(reference.getEOpposite())) {
                comparison = diff.getMatch().getComparison();
                for (Diff superSetDiff : comparison.getDifferences((EObject)superSet)) {
                    if (!(superSetDiff instanceof ReferenceChange) || superSetDiff.getSource() != diff.getSource() || ((ReferenceChange)superSetDiff).getReference() != superSet || superSetDiff.getMatch() != comparison.getMatch(diff.getValue())) continue;
                    if (ComparisonUtil.isAddOrSetDiff((Diff)diff) && ComparisonUtil.isAddOrSetDiff((Diff)superSetDiff)) {
                        diff.getImplies().add((Object)superSetDiff);
                        continue;
                    }
                    if (!ComparisonUtil.isDeleteOrUnsetDiff((Diff)diff) || !ComparisonUtil.isDeleteOrUnsetDiff((Diff)superSetDiff)) continue;
                    diff.getImpliedBy().add((Object)superSetDiff);
                }
            }
        }
    }

    private void deleteEnumerationLiteralClassifierChanges(ReferenceChange referenceChange) {
        if (this.isEnumerationLiteralClassifierChange(referenceChange)) {
            ComparisonUtil.delete((Diff)referenceChange);
        }
    }

    private boolean isEnumerationLiteralClassifierChange(ReferenceChange referenceChange) {
        return UMLPackage.Literals.INSTANCE_SPECIFICATION__CLASSIFIER.equals(referenceChange.getReference()) && this.getAnyMatchedEObject((Diff)referenceChange) instanceof EnumerationLiteral && referenceChange.getValue() instanceof Enumeration;
    }

    private EObject getAnyMatchedEObject(Diff diff) {
        Match match = diff.getMatch();
        EObject eObject = match.getLeft() != null ? match.getLeft() : (match.getRight() != null ? match.getRight() : match.getOrigin());
        return eObject;
    }
}

