/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.binary;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.diffmerge.structures.IProperty;
import org.eclipse.emf.diffmerge.structures.IPropertyValue;
import org.eclipse.emf.diffmerge.structures.PropertyValue;
import org.eclipse.emf.diffmerge.structures.binary.AbstractBinaryRelation;
import org.eclipse.emf.diffmerge.structures.binary.IBinaryRelation;
import org.eclipse.emf.diffmerge.structures.common.FLinkedList;

public class TypeRestrictedBinaryRelation<T, U>
extends AbstractBinaryRelation<T, U>
implements IBinaryRelation.RuntimeTyped<T, U> {
    private final IBinaryRelation<?, ?> _adapted;
    private final Class<T> _sourceType;
    private final Class<U> _targetType;
    protected final boolean _sourcesRequireFiltering;
    protected final boolean _targetsRequireFiltering;
    protected final Class<?> _originalSourceType;

    public TypeRestrictedBinaryRelation(IBinaryRelation<?, ?> toAdapt_p, Class<T> sourceType_p, Class<U> targetType_p) {
        super(toAdapt_p.getEqualityTester());
        this._adapted = toAdapt_p;
        this._sourceType = sourceType_p;
        this._targetType = targetType_p;
        if (toAdapt_p instanceof IBinaryRelation.RuntimeTyped) {
            IBinaryRelation.RuntimeTyped typedOriginalRelation = (IBinaryRelation.RuntimeTyped)toAdapt_p;
            this._originalSourceType = typedOriginalRelation.getSourceType();
            this._sourcesRequireFiltering = !this._originalSourceType.isAssignableFrom(this._sourceType);
            this._targetsRequireFiltering = !this._targetType.isAssignableFrom(typedOriginalRelation.getTargetType());
        } else {
            this._sourcesRequireFiltering = true;
            this._targetsRequireFiltering = true;
            this._originalSourceType = null;
        }
    }

    @Override
    public Collection<U> get(T element_p) {
        Collection<?> result;
        Collection<?> originalResult = this.getRaw(element_p);
        if (!this._targetsRequireFiltering || originalResult.isEmpty()) {
            result = originalResult;
        } else {
            result = new FLinkedList(this.getEqualityTester());
            Class<U> targetType = this.getTargetType();
            for (Object candidate : originalResult) {
                if (!targetType.isInstance(candidate)) continue;
                result.add(candidate);
            }
            result = Collections.unmodifiableCollection(result);
        }
        return result;
    }

    protected Collection<?> getRaw(T element_p) {
        Collection<Object> result;
        IBinaryRelation<?, ?> adaptedRelation = this.getAdaptedRelation();
        if (this._sourcesRequireFiltering && this._originalSourceType != null) {
            result = this._originalSourceType.isInstance(element_p) ? adaptedRelation.get(element_p) : Collections.emptySet();
        } else {
            try {
                result = adaptedRelation.get(element_p);
            }
            catch (ClassCastException e) {
                result = Collections.emptySet();
            }
        }
        return result;
    }

    public IBinaryRelation<?, ?> getAdaptedRelation() {
        return this._adapted;
    }

    @Override
    public Class<T> getSourceType() {
        return this._sourceType;
    }

    @Override
    public Class<U> getTargetType() {
        return this._targetType;
    }

    @Override
    public IPropertyValue<Boolean> isFunctional() {
        return this.trueForAdaptedOrUnknown(this.propertyIsFunctional());
    }

    @Override
    public IPropertyValue<Boolean> isInjective() {
        return this.trueForAdaptedOrUnknown(this.propertyIsInjective());
    }

    protected IPropertyValue<Boolean> trueForAdaptedOrUnknown(IProperty<Boolean> property_p) {
        IPropertyValue<Boolean> originalResult;
        IPropertyValue<Boolean> result = PropertyValue.unknownValue();
        IBinaryRelation<?, ?> adaptedRelation = this.getAdaptedRelation();
        if (adaptedRelation instanceof IBinaryRelation.WithProperties && (originalResult = ((IBinaryRelation.WithProperties)adaptedRelation).getProperty(property_p)).is(Boolean.TRUE)) {
            result = originalResult;
        }
        return result;
    }
}

