/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.adapt.inject;

import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import java.lang.annotation.Annotation;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.common.adapt.inject.AdapterMap;
import org.eclipse.gef.common.adapt.inject.AdapterMapImpl;
import org.eclipse.gef.common.reflect.Types;

public class AdapterMaps {
    private static AdapterMap get(Class<? extends IAdaptable> type) {
        return new AdapterMapImpl(type);
    }

    private static AdapterMap get(Class<? extends IAdaptable> type, AdapterKey<?> ... context) {
        AdapterMap.BoundAdapter[] ce = new AdapterMap.BoundAdapter[context.length];
        int i = 0;
        while (i < context.length) {
            ce[i] = new AdapterMapImpl.BoundAdapterImpl(Types.serialize(context[i].getKey()), context[i].getRole());
            ++i;
        }
        return new AdapterMapImpl(type, ce);
    }

    public static MapBinder<AdapterKey<?>, Object> getAdapterMapBinder(Binder binder, Class<? extends IAdaptable> adaptableType) {
        MapBinder adapterMapBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<AdapterKey<?>>(){}, (TypeLiteral)new TypeLiteral<Object>(){}, (Annotation)AdapterMaps.get(adaptableType));
        return adapterMapBinder;
    }

    public static MapBinder<AdapterKey<?>, Object> getAdapterMapBinder(Binder binder, Class<? extends IAdaptable> adaptableType, AdapterKey<?> ... adaptableContext) {
        if (!IAdaptable.Bound.class.isAssignableFrom(adaptableType)) {
            throw new IllegalArgumentException("In order to restrict adapter map bindings with a role, the IAdaptable has to be IAdaptable.Bound (with the role).");
        }
        MapBinder adapterMapBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<AdapterKey<?>>(){}, (TypeLiteral)new TypeLiteral<Object>(){}, (Annotation)AdapterMaps.get(adaptableType, adaptableContext));
        return adapterMapBinder;
    }

    private AdapterMaps() {
    }
}

