/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.nodes;

import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.fx.nodes.IConnectionInterpolator;
import org.eclipse.gef.fx.utils.Geometry2Shape;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.euclidean.Angle;
import org.eclipse.gef.geometry.euclidean.Vector;
import org.eclipse.gef.geometry.planar.AffineTransform;
import org.eclipse.gef.geometry.planar.BezierCurve;
import org.eclipse.gef.geometry.planar.ICurve;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Point;

public abstract class AbstractInterpolator
implements IConnectionInterpolator {
    protected void arrangeDecoration(Node decoration, Point offset, Vector direction) {
        AffineTransform transform = new AffineTransform().translate(offset.x, offset.y);
        if (!direction.isNull()) {
            Angle angleCW = new Vector(1.0, 0.0).getAngleCW(direction);
            transform.rotate(angleCW.rad(), 0.0, 0.0);
        }
        transform.translate(-NodeUtils.getShapeBounds(decoration).getX(), 0.0);
        decoration.getTransforms().setAll((Object[])new Transform[]{Geometry2FX.toFXAffine((AffineTransform)transform)});
    }

    private void arrangeEndDecoration(Node endDecoration, ICurve curve, Point endPoint) {
        if (endDecoration == null) {
            return;
        }
        if (curve == null || endPoint == null) {
            return;
        }
        BezierCurve[] beziers = curve.toBezier();
        if (beziers.length == 0) {
            return;
        }
        BezierCurve endDerivative = beziers[beziers.length - 1].getDerivative();
        Point slope = endDerivative.get(1.0);
        if (slope.equals(0.0, 0.0)) {
            slope = endDerivative.get(0.99);
        }
        Vector endDirection = new Vector(slope.getNegated());
        this.arrangeDecoration(endDecoration, endPoint, endDirection);
    }

    private void arrangeStartDecoration(Node startDecoration, ICurve curve, Point startPoint) {
        if (curve == null || startPoint == null) {
            return;
        }
        BezierCurve[] beziers = curve.toBezier();
        if (beziers.length == 0) {
            return;
        }
        BezierCurve startDerivative = beziers[0].getDerivative();
        Point slope = startDerivative.get(0.0);
        if (slope.equals(0.0, 0.0)) {
            slope = startDerivative.get(0.01);
        }
        Vector curveStartDirection = new Vector(slope);
        this.arrangeDecoration(startDecoration, startPoint, curveStartDirection);
    }

    protected Shape clipAtDecoration(Shape curveShape, Shape curveClip, Shape decoration) {
        Path decorationShapeBounds = new Path(Geometry2Shape.toPathElements(NodeUtils.localToScene((Node)decoration, (IGeometry)NodeUtils.getShapeBounds((Node)decoration)).toPath()));
        decorationShapeBounds.setFill((Paint)Color.RED);
        Shape clip = Shape.intersect((Shape)decorationShapeBounds, (Shape)curveShape);
        clip = Shape.subtract((Shape)clip, (Shape)decoration);
        clip = Shape.subtract((Shape)curveClip, (Shape)clip);
        return clip;
    }

    protected abstract ICurve computeCurve(Connection var1);

    @Override
    public void interpolate(Connection connection) {
        Node endDecoration;
        Node startDecoration;
        ICurve newGeometry = this.computeCurve(connection);
        GeometryNode curveNode = (GeometryNode)connection.getCurve();
        if (curveNode instanceof GeometryNode && !newGeometry.equals(curveNode.getGeometry())) {
            curveNode.setGeometry(newGeometry);
        }
        if ((startDecoration = connection.getStartDecoration()) != null) {
            this.arrangeStartDecoration(startDecoration, newGeometry, newGeometry.getP1());
        }
        if ((endDecoration = connection.getEndDecoration()) != null) {
            this.arrangeEndDecoration(endDecoration, newGeometry, newGeometry.getP2());
        }
        if (!(newGeometry.getBounds().isEmpty() || startDecoration == null && endDecoration == null)) {
            org.eclipse.gef.geometry.planar.Rectangle unionBoundsInCurveNode = new org.eclipse.gef.geometry.planar.Rectangle();
            ObservableList childrenUnmodifiable = curveNode.getChildrenUnmodifiable();
            for (Node child : childrenUnmodifiable) {
                Bounds boundsInParent = child.getBoundsInParent();
                org.eclipse.gef.geometry.planar.Rectangle rectangle = FX2Geometry.toRectangle((Bounds)boundsInParent);
                unionBoundsInCurveNode.union(rectangle);
            }
            Bounds visualBounds = curveNode.localToScene(Geometry2FX.toFXBounds((org.eclipse.gef.geometry.planar.Rectangle)unionBoundsInCurveNode));
            Rectangle clip = new Rectangle(visualBounds.getMinX(), visualBounds.getMinY(), visualBounds.getWidth(), visualBounds.getHeight());
            clip.setFill((Paint)Color.RED);
            if (startDecoration != null && startDecoration instanceof Shape) {
                clip = this.clipAtDecoration((Shape)curveNode.getGeometricShape(), (Shape)clip, (Shape)startDecoration);
            }
            if (endDecoration != null && endDecoration instanceof Shape) {
                clip = this.clipAtDecoration((Shape)curveNode.getGeometricShape(), (Shape)clip, (Shape)endDecoration);
            }
            AffineTransform sceneToLocalTx = NodeUtils.getSceneToLocalTx((Node)curveNode);
            clip.getTransforms().add((Object)Geometry2FX.toFXAffine((AffineTransform)sceneToLocalTx));
            curveNode.setClip((Node)clip);
        } else {
            curveNode.setClip(null);
        }
    }
}

