/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.operations.BendContentOperation;
import org.eclipse.gef.mvc.fx.operations.BendVisualOperation;
import org.eclipse.gef.mvc.fx.parts.IBendableContentPart;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.BendConnectionPolicy;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class ConnectedSupport
extends IAdaptable.Bound.Impl<IViewer> {
    private List<BendVisualOperation> operations = new ArrayList<BendVisualOperation>();
    private IVisualPart<?>[] parts;
    private BendConnectionPolicy[] policies;
    private boolean[] wasRefresh;

    public void abort() {
        if (this.parts != null) {
            int i = 0;
            while (i < this.parts.length) {
                this.policies[i].rollback();
                this.parts[i].setRefreshVisual(this.wasRefresh[i]);
                ++i;
            }
        }
        this.parts = null;
        this.policies = null;
        this.wasRefresh = null;
        this.abortHints();
    }

    private void abortHints() {
        try {
            for (BendVisualOperation op : this.operations) {
                op.undo(null, null);
            }
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public void commit() {
        if (this.parts != null) {
            int i = 0;
            while (i < this.parts.length) {
                this.policies[i].normalize();
                try {
                    this.parts[i].getViewer().getDomain().execute(this.policies[i].commit(), null);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                this.parts[i].setRefreshVisual(this.wasRefresh[i]);
                ++i;
            }
        }
        this.parts = null;
        this.policies = null;
        this.wasRefresh = null;
        this.commitHints();
    }

    private void commitHints() {
        for (BendVisualOperation op : this.operations) {
            try {
                ((IViewer)this.getAdaptable()).getDomain().execute(op, null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            BendContentOperation bendContentOperation = new BendContentOperation(op.getPart(), op.getInitialBendPoints(), op.getFinalBendPoints());
            try {
                ((IViewer)this.getAdaptable()).getDomain().execute(bendContentOperation, null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void init(List<? extends IVisualPart<? extends Node>> anchorages) {
        void var3_6;
        ArrayList<IVisualPart> targetParts = new ArrayList<IVisualPart>();
        for (IVisualPart<? extends Node> iVisualPart : anchorages) {
            for (IVisualPart anchored : iVisualPart.getAnchoredsUnmodifiable()) {
                BendConnectionPolicy bendConnectionPolicy;
                if (anchorages.contains(anchored) || targetParts.contains(anchored) || !(anchored instanceof IContentPart) || (bendConnectionPolicy = (BendConnectionPolicy)anchored.getAdapter(BendConnectionPolicy.class)) == null || targetParts.contains(anchored)) continue;
                targetParts.add(anchored);
            }
        }
        this.parts = targetParts.toArray(new IVisualPart[0]);
        this.wasRefresh = new boolean[this.parts.length];
        this.policies = new BendConnectionPolicy[this.parts.length];
        boolean bl = false;
        while (var3_6 < this.parts.length) {
            this.wasRefresh[var3_6] = this.parts[var3_6].isRefreshVisual();
            this.parts[var3_6].setRefreshVisual(false);
            this.policies[var3_6] = (BendConnectionPolicy)this.parts[var3_6].getAdapter(BendConnectionPolicy.class);
            this.policies[var3_6].init();
            this.policies[var3_6].move(new Point(), new Point());
            ++var3_6;
        }
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        set.addAll(anchorages);
        ArrayList<IBendableContentPart> startHintMovable = new ArrayList<IBendableContentPart>();
        ArrayList<IBendableContentPart> endHintMovable = new ArrayList<IBendableContentPart>();
        ArrayList<IBendableContentPart> hintsMovable = new ArrayList<IBendableContentPart>();
        for (IVisualPart<? extends Node> targetPart : anchorages) {
            for (IVisualPart anchored : targetPart.getAnchoredsUnmodifiable()) {
                IContentPart<? extends Node> anchoragePart;
                Object contentAnchorage;
                IBendableContentPart bendable;
                List<IBendableContentPart.BendPoint> bendPoints;
                if (!(anchored instanceof IBendableContentPart) || (bendPoints = (bendable = (IBendableContentPart)anchored).getContentBendPoints()) == null || bendPoints.isEmpty()) continue;
                if (bendPoints.get(0).isAttached()) {
                    contentAnchorage = bendPoints.get(0).getContentAnchorage();
                    anchoragePart = ((IViewer)this.getAdaptable()).getContentPartMap().get(contentAnchorage);
                    if (set.contains(anchoragePart)) {
                        startHintMovable.add(bendable);
                    }
                }
                if (bendPoints.get(bendPoints.size() - 1).isAttached()) {
                    contentAnchorage = bendPoints.get(bendPoints.size() - 1).getContentAnchorage();
                    anchoragePart = ((IViewer)this.getAdaptable()).getContentPartMap().get(contentAnchorage);
                    if (set.contains(anchoragePart)) {
                        endHintMovable.add(bendable);
                    }
                }
                if (!startHintMovable.contains(anchored) || !endHintMovable.contains(anchored) || set.contains(anchored)) continue;
                hintsMovable.add((IBendableContentPart)anchored);
            }
        }
        this.initHints(hintsMovable);
    }

    private void initHints(Collection<? extends IBendableContentPart<? extends Node>> hintsMovable) {
        this.operations.clear();
        for (IBendableContentPart<? extends Node> iBendableContentPart : hintsMovable) {
            this.operations.add(new BendVisualOperation(iBendableContentPart));
        }
    }

    public void normalizeConnected() {
        if (this.parts != null) {
            int i = 0;
            while (i < this.parts.length) {
                this.policies[i].move(new Point(), new Point());
                this.policies[i].normalize();
                ++i;
            }
        }
    }

    public void relocateHints(Dimension delta) {
        for (BendVisualOperation op : this.operations) {
            ArrayList<IBendableContentPart.BendPoint> relocatedBendPoints = new ArrayList<IBendableContentPart.BendPoint>();
            for (IBendableContentPart.BendPoint bp : op.getInitialBendPoints()) {
                if (bp.isAttached()) {
                    relocatedBendPoints.add(new IBendableContentPart.BendPoint(bp.getContentAnchorage(), bp.getPosition().getTranslated(delta)));
                    continue;
                }
                relocatedBendPoints.add(new IBendableContentPart.BendPoint(bp.getPosition().getTranslated(delta)));
            }
            op.setFinalBendPoints(relocatedBendPoints);
            try {
                op.execute(null, null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }
}

