/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.services.impl;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.graphiti.dt.AbstractDiagramTypeProvider;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.platform.ga.IGraphicsAlgorithmRenderer;
import org.eclipse.graphiti.platform.ga.IGraphicsAlgorithmRendererFactory;
import org.eclipse.graphiti.platform.ga.IRendererContext;
import org.eclipse.graphiti.platform.ga.IVisualState;
import org.eclipse.graphiti.platform.ga.IVisualStateChangeListener;
import org.eclipse.graphiti.platform.ga.IVisualStateHolder;
import org.eclipse.graphiti.platform.ga.VisualState;
import org.eclipse.graphiti.platform.ga.VisualStateChangedEvent;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;

public class DummyExportAsImageDiagramTypeProvider
extends AbstractDiagramTypeProvider {
    public IFeatureProvider getFeatureProvider() {
        return new DefaultFeatureProvider((IDiagramTypeProvider)this);
    }

    public IGraphicsAlgorithmRendererFactory getGraphicsAlgorithmRendererFactory() {
        return new DummyExportAsImageAlgorithmRendererFactory();
    }

    private class DummyExportAsImageAlgorithmRendererFactory
    implements IGraphicsAlgorithmRendererFactory {
        private DummyExportAsImageAlgorithmRendererFactory() {
        }

        public IGraphicsAlgorithmRenderer createGraphicsAlgorithmRenderer(IRendererContext context) {
            return new NoRendererAvailableFigure();
        }
    }

    private class NoRendererAvailableFigure
    extends RectangleFigure
    implements IGraphicsAlgorithmRenderer,
    IVisualStateHolder,
    IVisualStateChangeListener {
        private Insets defaultFigureInsets = new Insets(2);
        private VisualState visualState;

        public IVisualState getVisualState() {
            if (this.visualState == null) {
                this.visualState = new VisualState();
                this.visualState.addChangeListener((IVisualStateChangeListener)this);
            }
            return this.visualState;
        }

        public void visualStateChanged(VisualStateChangedEvent e) {
            this.setBackgroundColor(ColorConstants.white);
            this.setLineWidth(1);
        }

        protected void fillShape(Graphics g) {
            g.setAntialias(1);
            Rectangle innerBounds = this.getInnerBounds();
            g.setBackgroundColor(ColorConstants.white);
            g.fillRectangle(new Rectangle(innerBounds.getLeft(), innerBounds.getRight()));
        }

        protected void outlineShape(Graphics g) {
            Rectangle innerBounds = this.getInnerBounds();
            g.drawLine(innerBounds.getTopLeft(), innerBounds.getTopRight());
            g.drawLine(innerBounds.getTopRight(), innerBounds.getBottomRight());
            g.drawLine(innerBounds.getBottomRight(), innerBounds.getBottomLeft());
            g.drawLine(innerBounds.getBottomLeft(), innerBounds.getTopLeft());
            g.setForegroundColor(ColorConstants.black);
            g.drawText("Sorry!\n\nThis tool specific shape\ncannot be rendered.", innerBounds.x + 10, innerBounds.y + 10);
        }

        private Rectangle getInnerBounds() {
            return this.getBounds().getCopy().getShrinked(this.defaultFigureInsets);
        }
    }
}

