/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.core.nd.ITypeFactory;
import org.eclipse.jdt.internal.core.nd.NdNodeTypeRegistry;
import org.eclipse.jdt.internal.core.nd.db.Chunk;
import org.eclipse.jdt.internal.core.nd.db.Database;
import org.eclipse.jdt.internal.core.nd.db.IndexException;

public class MemoryStats {
    public static final int TOTAL_MALLOC_POOLS = 64;
    public static final int SIZE = 64 * PoolStats.RECORD_SIZE;
    private Map<Integer, PoolStats> stats = new HashMap<Integer, PoolStats>();
    public final long address;
    private Chunk db;

    public MemoryStats(Chunk db, long address) {
        this.db = db;
        this.address = address;
    }

    public void printMemoryStats(NdNodeTypeRegistry<?> nodeRegistry) {
        StringBuilder builder = new StringBuilder();
        for (PoolStats next : this.getSortedPools()) {
            builder.append(this.getPoolName(nodeRegistry, next.poolId));
            builder.append(" ");
            builder.append(next.numAllocations);
            builder.append(" allocations, ");
            builder.append(Database.formatByteString(next.totalSize));
            builder.append("\n");
        }
        System.out.println(builder.toString());
    }

    private String getPoolName(NdNodeTypeRegistry<?> registry, int poolId) {
        ITypeFactory<?> type;
        switch (poolId) {
            case 0: {
                return "Miscellaneous";
            }
            case 1: {
                return "B-Trees";
            }
            case 2: {
                return "DB Properties";
            }
            case 3: {
                return "Long Strings";
            }
            case 4: {
                return "Short Strings";
            }
            case 5: {
                return "Linked Lists";
            }
            case 6: {
                return "String Sets";
            }
            case 7: {
                return "Growable Arrays";
            }
        }
        if (poolId >= 256 && (type = registry.getClassForType((short)(poolId - 256))) != null) {
            return type.getElementClass().getSimpleName();
        }
        return "Unknown memory pool " + poolId;
    }

    public Collection<PoolStats> getPools() {
        return this.stats.values();
    }

    public List<PoolStats> getSortedPools() {
        ArrayList<PoolStats> unsorted = new ArrayList<PoolStats>();
        unsorted.addAll(this.getPools());
        Collections.sort(unsorted, new Comparator<PoolStats>(){

            @Override
            public int compare(PoolStats o1, PoolStats o2) {
                return Long.signum(o2.totalSize - o1.totalSize);
            }
        });
        return unsorted;
    }

    public void recordMalloc(short poolId, long size) {
        PoolStats toRecord = this.getPoolStats(poolId);
        toRecord.setAllocations(this.db, toRecord.numAllocations + 1L);
        toRecord.setTotalSize(this.db, toRecord.totalSize + size);
    }

    private PoolStats getPoolStats(short poolId) {
        PoolStats result;
        if (this.stats.isEmpty()) {
            this.refresh();
        }
        if ((result = this.stats.get(poolId)) == null) {
            if (this.stats.size() >= 64) {
                throw new IndexException("Too many malloc pools. Please increase the size of TOTAL_MALLOC_POOLS.");
            }
            int idx = 0;
            while (true) {
                PoolStats nextPool = this.readPool(idx);
                if (idx > 0 && nextPool.poolId == 0) break;
                if (nextPool.poolId == poolId) {
                    throw new IllegalStateException("The stats were out of sync with the database.");
                }
                if (nextPool.poolId > poolId) break;
                ++idx;
            }
            int lastIdx = idx;
            while (true) {
                PoolStats nextPool = this.readPool(lastIdx);
                if (lastIdx > 0 && nextPool.poolId == 0) break;
                ++lastIdx;
            }
            int shiftIdx = lastIdx;
            while (shiftIdx > idx) {
                PoolStats writeTo = this.readPool(shiftIdx);
                PoolStats readFrom = this.readPool(shiftIdx - 1);
                writeTo.setAllocations(this.db, readFrom.numAllocations);
                writeTo.setTotalSize(this.db, readFrom.totalSize);
                writeTo.setPoolId(this.db, readFrom.poolId);
                --shiftIdx;
            }
            result = this.readPool(idx);
            result.setAllocations(this.db, 0L);
            result.setTotalSize(this.db, 0L);
            result.setPoolId(this.db, poolId);
            this.refresh();
            result = this.stats.get(poolId);
        }
        return result;
    }

    private List<PoolStats> loadStats() {
        ArrayList<PoolStats> result = new ArrayList<PoolStats>();
        int idx = 0;
        while (idx < 64) {
            PoolStats next = this.readPool(idx);
            if (idx > 0 && next.poolId == 0) break;
            result.add(next);
            ++idx;
        }
        return result;
    }

    public void refresh() {
        this.stats.clear();
        for (PoolStats next : this.loadStats()) {
            this.stats.put(Integer.valueOf(next.poolId), next);
        }
    }

    public PoolStats readPool(int idx) {
        return new PoolStats(this.db, this.address + (long)(idx * PoolStats.RECORD_SIZE));
    }

    public void recordFree(short poolId, long size) {
        PoolStats toRecord = this.getPoolStats(poolId);
        if (toRecord.numAllocations <= 0L || toRecord.totalSize < size) {
            throw new IndexException("Attempted to free more memory from pool " + poolId + " than was ever allocated");
        }
        toRecord.setAllocations(this.db, toRecord.numAllocations - 1L);
        toRecord.setTotalSize(this.db, toRecord.totalSize - size);
    }

    public static final class PoolStats {
        public static int POOL_ID_OFFSET = 0;
        public static int NUM_ALLOCATIONS_OFFSET = POOL_ID_OFFSET + 2;
        public static int TOTAL_SIZE_OFFSET = NUM_ALLOCATIONS_OFFSET + 8;
        public static final int RECORD_SIZE = TOTAL_SIZE_OFFSET + 8;
        short poolId;
        long numAllocations;
        long totalSize;
        long address;

        public PoolStats(Chunk db, long address) {
            this.address = address;
            this.poolId = db.getShort((long)POOL_ID_OFFSET + address);
            this.numAllocations = db.getLong((long)NUM_ALLOCATIONS_OFFSET + address);
            this.totalSize = db.getLong((long)TOTAL_SIZE_OFFSET + address);
        }

        public void setAllocations(Chunk db, long numAllocations) {
            this.numAllocations = numAllocations;
            db.putLong(this.address + (long)NUM_ALLOCATIONS_OFFSET, numAllocations);
        }

        public void setTotalSize(Chunk db, long totalSize) {
            this.totalSize = totalSize;
            db.putLong(this.address + (long)TOTAL_SIZE_OFFSET, totalSize);
        }

        public void setPoolId(Chunk db, short poolId) {
            this.poolId = poolId;
            db.putShort(this.address + (long)POOL_ID_OFFSET, poolId);
        }

        public long getNumAllocations() {
            return this.numAllocations;
        }

        public short getPoolId() {
            return this.poolId;
        }

        public long getTotalSize() {
            return this.totalSize;
        }
    }
}

