/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.junit.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.LayoutUtil;
import org.eclipse.jdt.internal.junit.wizards.WizardMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class NewTestCaseWizardPageTwo
extends WizardPage {
    private static final String PAGE_NAME = "NewTestCaseCreationWizardPage2";
    private static final String STORE_USE_TASKMARKER = "NewTestCaseCreationWizardPage2.USE_TASKMARKER";
    private static final String STORE_CREATE_FINAL_METHOD_STUBS = "NewTestCaseCreationWizardPage2.CREATE_FINAL_METHOD_STUBS";
    private IType fClassToTest;
    private Button fCreateFinalMethodStubsButton;
    private Button fCreateTasksButton;
    private ContainerCheckedTreeViewer fMethodsTree;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private Label fSelectedMethodsLabel;
    private Object[] fCheckedObjects;
    private boolean fCreateFinalStubs;
    private boolean fCreateTasks;

    public NewTestCaseWizardPageTwo() {
        super(PAGE_NAME);
        this.setTitle(WizardMessages.NewTestCaseWizardPageTwo_title);
        this.setDescription(WizardMessages.NewTestCaseWizardPageTwo_description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.createMethodsTreeControls(container);
        this.createSpacer(container);
        this.createButtonChoices(container);
        this.setControl((Control)container);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.jdt.junit.new_testcase_wizard_page2_context");
    }

    private void createButtonChoices(Composite container) {
        Composite prefixContainer = new Composite(container, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 1;
        prefixContainer.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        prefixContainer.setLayout((Layout)layout);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewTestCaseWizardPageTwo.this.doCheckBoxSelected(e.widget);
            }
        };
        this.fCreateFinalMethodStubsButton = this.createCheckBox(prefixContainer, WizardMessages.NewTestCaseWizardPageTwo_create_final_method_stubs_text, (SelectionListener)listener);
        this.fCreateTasksButton = this.createCheckBox(prefixContainer, WizardMessages.NewTestCaseWizardPageTwo_create_tasks_text, (SelectionListener)listener);
    }

    private Button createCheckBox(Composite parent, String name, SelectionListener listener) {
        Button button = new Button(parent, 16416);
        button.setText(name);
        button.setEnabled(true);
        button.setSelection(true);
        button.addSelectionListener(listener);
        GridData gd = new GridData(4, 2, false, false);
        button.setLayoutData((Object)gd);
        return button;
    }

    private void doCheckBoxSelected(Widget widget) {
        if (widget == this.fCreateFinalMethodStubsButton) {
            this.fCreateFinalStubs = this.fCreateFinalMethodStubsButton.getSelection();
        } else if (widget == this.fCreateTasksButton) {
            this.fCreateTasks = this.fCreateTasksButton.getSelection();
        }
        this.saveWidgetValues();
    }

    private void createMethodsTreeControls(Composite container) {
        Label label = new Label(container, 16448);
        label.setFont(container.getFont());
        label.setText(WizardMessages.NewTestCaseWizardPageTwo_methods_tree_label);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fMethodsTree = new ContainerCheckedTreeViewer(container, 2048);
        gd = new GridData(1808);
        gd.heightHint = 180;
        this.fMethodsTree.getTree().setLayoutData((Object)gd);
        this.fMethodsTree.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider());
        this.fMethodsTree.setAutoExpandLevel(2);
        this.fMethodsTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                NewTestCaseWizardPageTwo.this.doCheckedStateChanged();
            }
        });
        this.fMethodsTree.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IMethod) {
                    IMethod method = (IMethod)element;
                    return !method.getElementName().equals("<clinit>");
                }
                return true;
            }
        });
        Composite buttonContainer = new Composite(container, 0);
        gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fSelectAllButton = new Button(buttonContainer, 8);
        this.fSelectAllButton.setText(WizardMessages.NewTestCaseWizardPageTwo_selectAll);
        gd = new GridData(770);
        this.fSelectAllButton.setLayoutData((Object)gd);
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewTestCaseWizardPageTwo.this.fMethodsTree.setCheckedElements((Object[])NewTestCaseWizardPageTwo.this.fMethodsTree.getInput());
                NewTestCaseWizardPageTwo.this.doCheckedStateChanged();
            }
        });
        LayoutUtil.setButtonDimensionHint(this.fSelectAllButton);
        this.fDeselectAllButton = new Button(buttonContainer, 8);
        this.fDeselectAllButton.setText(WizardMessages.NewTestCaseWizardPageTwo_deselectAll);
        gd = new GridData(770);
        this.fDeselectAllButton.setLayoutData((Object)gd);
        this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewTestCaseWizardPageTwo.this.fMethodsTree.setCheckedElements(new Object[0]);
                NewTestCaseWizardPageTwo.this.doCheckedStateChanged();
            }
        });
        LayoutUtil.setButtonDimensionHint(this.fDeselectAllButton);
        this.fSelectedMethodsLabel = new Label(container, 16384);
        this.fSelectedMethodsLabel.setFont(container.getFont());
        this.doCheckedStateChanged();
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.fSelectedMethodsLabel.setLayoutData((Object)gd);
        Label emptyLabel = new Label(container, 16384);
        gd = new GridData();
        gd.horizontalSpan = 1;
        emptyLabel.setLayoutData((Object)gd);
    }

    private void createSpacer(Composite container) {
        Label spacer = new Label(container, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.heightHint = 4;
        spacer.setLayoutData((Object)data);
    }

    public void setClassUnderTest(IType classUnderTest) {
        this.fClassToTest = classUnderTest;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.fClassToTest == null) {
                return;
            }
            ArrayList<IType> types = null;
            try {
                ITypeHierarchy hierarchy = this.fClassToTest.newSupertypeHierarchy(null);
                IType[] superTypes = this.fClassToTest.isClass() ? hierarchy.getAllSuperclasses(this.fClassToTest) : (this.fClassToTest.isInterface() ? hierarchy.getAllSuperInterfaces(this.fClassToTest) : new IType[]{});
                types = new ArrayList(superTypes.length + 1);
                types.add(this.fClassToTest);
                types.addAll(Arrays.asList(superTypes));
            }
            catch (JavaModelException e) {
                JUnitPlugin.log(e);
            }
            if (types == null) {
                types = new ArrayList<IType>();
            }
            this.fMethodsTree.setContentProvider((IContentProvider)new MethodsTreeContentProvider(types.toArray()));
            this.fMethodsTree.setInput((Object)types.toArray());
            this.fMethodsTree.setSelection((ISelection)new StructuredSelection((Object)this.fClassToTest), true);
            this.doCheckedStateChanged();
            this.fMethodsTree.getControl().setFocus();
        }
    }

    public IMethod[] getCheckedMethods() {
        int methodCount = 0;
        int i = 0;
        while (i < this.fCheckedObjects.length) {
            if (this.fCheckedObjects[i] instanceof IMethod) {
                ++methodCount;
            }
            ++i;
        }
        IMethod[] checkedMethods = new IMethod[methodCount];
        int j = 0;
        int i2 = 0;
        while (i2 < this.fCheckedObjects.length) {
            if (this.fCheckedObjects[i2] instanceof IMethod) {
                checkedMethods[j] = (IMethod)this.fCheckedObjects[i2];
                ++j;
            }
            ++i2;
        }
        return checkedMethods;
    }

    public boolean isCreateTasks() {
        return this.fCreateTasks;
    }

    public boolean getCreateFinalMethodStubsButtonSelection() {
        return this.fCreateFinalStubs;
    }

    private void doCheckedStateChanged() {
        Object[] checked = this.fMethodsTree.getCheckedElements();
        this.fCheckedObjects = checked;
        int checkedMethodCount = 0;
        Object[] objectArray = checked;
        int n = checked.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IMethod) {
                ++checkedMethodCount;
            }
            ++n2;
        }
        String label = "";
        label = checkedMethodCount == 1 ? Messages.format((String)WizardMessages.NewTestCaseWizardPageTwo_selected_methods_label_one, (Object)checkedMethodCount) : Messages.format((String)WizardMessages.NewTestCaseWizardPageTwo_selected_methods_label_many, (Object)checkedMethodCount);
        this.fSelectedMethodsLabel.setText(label);
    }

    public IMethod[] getAllMethods() {
        return ((MethodsTreeContentProvider)this.fMethodsTree.getContentProvider()).getAllMethods();
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fCreateTasks = settings.getBoolean(STORE_USE_TASKMARKER);
            this.fCreateTasksButton.setSelection(this.fCreateTasks);
            this.fCreateFinalStubs = settings.getBoolean(STORE_CREATE_FINAL_METHOD_STUBS);
            this.fCreateFinalMethodStubsButton.setSelection(this.fCreateFinalStubs);
        }
    }

    private void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_USE_TASKMARKER, this.fCreateTasks);
            settings.put(STORE_CREATE_FINAL_METHOD_STUBS, this.fCreateFinalStubs);
        }
    }

    private static class MethodsTreeContentProvider
    implements ITreeContentProvider {
        private Object[] fTypes;
        private IMethod[] fMethods;
        private final Object[] fEmpty = new Object[0];

        public MethodsTreeContentProvider(Object[] types) {
            this.fTypes = types;
            Vector<IMethod> methods = new Vector<IMethod>();
            int i = types.length - 1;
            while (i > -1) {
                Object object = types[i];
                if (object instanceof IType) {
                    IType type = (IType)object;
                    try {
                        IMethod[] currMethods = type.getMethods();
                        int j = 0;
                        while (j < currMethods.length) {
                            block8: {
                                IMethod currMethod = currMethods[j];
                                int flags = currMethod.getFlags();
                                if (!Flags.isPrivate((int)flags) && !Flags.isSynthetic((int)flags)) {
                                    int k = 0;
                                    while (k < methods.size()) {
                                        IMethod m = (IMethod)methods.get(k);
                                        if (m.getElementName().equals(currMethod.getElementName()) && m.getSignature().equals(currMethod.getSignature())) {
                                            methods.set(k, currMethod);
                                            break block8;
                                        }
                                        ++k;
                                    }
                                    methods.add(currMethod);
                                }
                            }
                            ++j;
                        }
                    }
                    catch (JavaModelException e) {
                        JUnitPlugin.log(e);
                    }
                }
                --i;
            }
            this.fMethods = new IMethod[methods.size()];
            methods.copyInto(this.fMethods);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IType) {
                IType parentType = (IType)parentElement;
                ArrayList<IMethod> result = new ArrayList<IMethod>(this.fMethods.length);
                int i = 0;
                while (i < this.fMethods.length) {
                    if (this.fMethods[i].getDeclaringType().equals(parentType)) {
                        result.add(this.fMethods[i]);
                    }
                    ++i;
                }
                return result.toArray();
            }
            return this.fEmpty;
        }

        public Object getParent(Object element) {
            if (element instanceof IMethod) {
                return ((IMethod)element).getDeclaringType();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.fTypes;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public IMethod[] getAllMethods() {
            return this.fMethods;
        }
    }
}

