/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.transport.AmazonS3;
import org.kohsuke.args4j.Argument;

@Command(name="amazon-s3-client", common=false, usage="usage_CommandLineClientForamazonsS3Service")
class AmazonS3Client
extends TextBuiltin {
    @Argument(index=0, metaVar="metaVar_connProp", required=true)
    private File propertyFile;
    @Argument(index=1, metaVar="metaVar_op", required=true)
    private String op;
    @Argument(index=2, metaVar="metaVar_bucket", required=true)
    private String bucket;
    @Argument(index=3, metaVar="metaVar_KEY", required=true)
    private String key;

    AmazonS3Client() {
    }

    @Override
    protected final boolean requiresRepository() {
        return false;
    }

    @Override
    protected void run() throws Exception {
        block28: {
            AmazonS3 s3 = new AmazonS3(this.properties());
            if ("get".equals(this.op)) {
                URLConnection c = s3.get(this.bucket, this.key);
                int len = c.getContentLength();
                Throwable throwable = null;
                Object var5_13 = null;
                try (InputStream in = c.getInputStream();){
                    this.outw.flush();
                    byte[] tmp = new byte[2048];
                    while (len > 0) {
                        int n = in.read(tmp);
                        if (n < 0) {
                            throw new EOFException(MessageFormat.format(CLIText.get().expectedNumberOfbytes, len));
                        }
                        this.outs.write(tmp, 0, n);
                        len -= n;
                    }
                    this.outs.flush();
                    break block28;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if ("ls".equals(this.op) || "list".equals(this.op)) {
                for (String k : s3.list(this.bucket, this.key)) {
                    this.outw.println(k);
                }
            } else if ("rm".equals(this.op) || "delete".equals(this.op)) {
                s3.delete(this.bucket, this.key);
            } else {
                if ("put".equals(this.op)) {
                    Throwable throwable = null;
                    Object var3_8 = null;
                    try (OutputStream os = s3.beginPut(this.bucket, this.key, null, null);){
                        int n;
                        byte[] tmp = new byte[2048];
                        while ((n = this.ins.read(tmp)) > 0) {
                            os.write(tmp, 0, n);
                        }
                        break block28;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                throw AmazonS3Client.die(MessageFormat.format(CLIText.get().unsupportedOperation, this.op));
            }
        }
    }

    private Properties properties() {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (FileInputStream in = new FileInputStream(this.propertyFile);){
                Properties p = new Properties();
                p.load(in);
                return p;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw AmazonS3Client.die(MessageFormat.format(CLIText.get().noSuchFile, this.propertyFile), (Throwable)e);
        }
        catch (IOException e) {
            throw AmazonS3Client.die(MessageFormat.format(CLIText.get().cannotReadBecause, this.propertyFile, e.getMessage()), (Throwable)e);
        }
    }
}

