/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.BufferedWriter;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.Die;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.internal.SshDriver;
import org.eclipse.jgit.pgm.opt.CmdLineParser;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.sshd.DefaultProxyDataFactory;
import org.eclipse.jgit.transport.sshd.JGitKeyCache;
import org.eclipse.jgit.transport.sshd.KeyCache;
import org.eclipse.jgit.transport.sshd.ProxyDataFactory;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.eclipse.jgit.util.io.ThrowingPrintWriter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;

public abstract class TextBuiltin {
    private String commandName;
    @Option(name="--help", usage="usage_displayThisHelpText", aliases={"-h"})
    private boolean help;
    @Option(name="--ssh", usage="usage_sshDriver")
    private SshDriver sshDriver = SshDriver.JSCH;
    protected InputStream ins;
    protected ThrowingPrintWriter outw;
    protected OutputStream outs;
    protected ThrowingPrintWriter errw;
    protected OutputStream errs;
    protected Repository db;
    protected String gitdir;
    protected RevWalk argWalk;

    final void setCommandName(String name) {
        this.commandName = name;
    }

    protected boolean requiresRepository() {
        return true;
    }

    public void initRaw(Repository repository, String gitDir, InputStream input, OutputStream output, OutputStream error) {
        this.ins = input;
        this.outs = output;
        this.errs = error;
        this.init(repository, gitDir);
    }

    private Charset getLogOutputEncodingCharset(Repository repository) {
        String logOutputEncoding;
        if (repository != null && (logOutputEncoding = repository.getConfig().getString("i18n", null, "logOutputEncoding")) != null) {
            try {
                return Charset.forName(logOutputEncoding);
            }
            catch (IllegalArgumentException e) {
                throw TextBuiltin.die(CLIText.get().cannotCreateOutputStream, (Throwable)e);
            }
        }
        return StandardCharsets.UTF_8;
    }

    protected void init(Repository repository, String gitDir) {
        Charset charset = this.getLogOutputEncodingCharset(repository);
        if (this.ins == null) {
            this.ins = new FileInputStream(FileDescriptor.in);
        }
        if (this.outs == null) {
            this.outs = new FileOutputStream(FileDescriptor.out);
        }
        if (this.errs == null) {
            this.errs = new FileOutputStream(FileDescriptor.err);
        }
        this.outw = new ThrowingPrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.outs, charset)));
        this.errw = new ThrowingPrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.errs, charset)));
        if (repository != null && repository.getDirectory() != null) {
            this.db = repository;
            this.gitdir = repository.getDirectory().getAbsolutePath();
        } else {
            this.db = repository;
            this.gitdir = gitDir;
        }
    }

    public final void execute(String[] args) throws Exception {
        this.parseArguments(args);
        switch (this.sshDriver) {
            case APACHE: {
                SshdSessionFactory factory = new SshdSessionFactory((KeyCache)new JGitKeyCache(), (ProxyDataFactory)new DefaultProxyDataFactory());
                Runtime.getRuntime().addShutdownHook(new Thread(() -> factory.close()));
                SshSessionFactory.setInstance((SshSessionFactory)factory);
                break;
            }
            default: {
                SshSessionFactory.setInstance(null);
            }
        }
        this.run();
    }

    protected void parseArguments(String[] args) throws IOException {
        CmdLineParser clp = new CmdLineParser(this);
        this.help = TextBuiltin.containsHelp(args);
        try {
            clp.parseArgument(args);
        }
        catch (CmdLineException err) {
            this.errw.println(CLIText.fatalError(err.getMessage()));
            if (this.help) {
                this.printUsage("", clp);
            }
            throw TextBuiltin.die(true, (Throwable)err);
        }
        if (this.help) {
            this.printUsage("", clp);
            throw new TerminatedByHelpException();
        }
        this.argWalk = clp.getRevWalkGently();
    }

    public void printUsageAndExit(CmdLineParser clp) throws IOException {
        this.printUsageAndExit("", clp);
    }

    public void printUsageAndExit(String message, CmdLineParser clp) throws IOException {
        this.printUsage(message, clp);
        throw TextBuiltin.die(true);
    }

    protected void printUsage(String message, CmdLineParser clp) throws IOException {
        this.errw.println(message);
        this.errw.print((Object)"jgit ");
        this.errw.print((Object)this.commandName);
        clp.printSingleLineUsage((Writer)this.errw, this.getResourceBundle());
        this.errw.println();
        this.errw.println();
        clp.printUsage((Writer)this.errw, this.getResourceBundle());
        this.errw.println();
        this.errw.flush();
    }

    public ThrowingPrintWriter getErrorWriter() {
        return this.errw;
    }

    public ThrowingPrintWriter getOutputWriter() {
        return this.outw;
    }

    protected ResourceBundle getResourceBundle() {
        return CLIText.get().resourceBundle();
    }

    protected abstract void run() throws Exception;

    public Repository getRepository() {
        return this.db;
    }

    ObjectId resolve(String s) throws IOException {
        ObjectId r = this.db.resolve(s);
        if (r == null) {
            throw TextBuiltin.die(MessageFormat.format(CLIText.get().notARevision, s));
        }
        return r;
    }

    protected static Die die(String why) {
        return new Die(why);
    }

    protected static Die die(String why, Throwable cause) {
        return new Die(why, cause);
    }

    protected static Die die(boolean aborted) {
        return new Die(aborted);
    }

    protected static Die die(boolean aborted, Throwable cause) {
        return new Die(aborted, cause);
    }

    String abbreviateRef(String dst, boolean abbreviateRemote) {
        if (dst.startsWith("refs/heads/")) {
            dst = dst.substring("refs/heads/".length());
        } else if (dst.startsWith("refs/tags/")) {
            dst = dst.substring("refs/tags/".length());
        } else if (abbreviateRemote && dst.startsWith("refs/remotes/")) {
            dst = dst.substring("refs/remotes/".length());
        }
        return dst;
    }

    public static boolean containsHelp(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.equals("-h") || str.equals("--help")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static class TerminatedByHelpException
    extends Die {
        private static final long serialVersionUID = 1L;

        public TerminatedByHelpException() {
            super(true);
        }
    }
}

