/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.EOFException;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.transport.parser.FirstWant;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.FetchV0Request;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.ProtocolV2Parser;
import org.eclipse.jgit.transport.TransferConfig;

final class ProtocolV0Parser {
    private final TransferConfig transferConfig;

    ProtocolV0Parser(TransferConfig transferConfig) {
        this.transferConfig = transferConfig;
    }

    FetchV0Request recvWants(PacketLineIn pckIn) throws PackProtocolException, IOException {
        FetchV0Request.Builder reqBuilder = new FetchV0Request.Builder();
        boolean isFirst = true;
        boolean filterReceived = false;
        while (true) {
            String line;
            try {
                line = pckIn.readString();
            }
            catch (EOFException eof) {
                if (isFirst) break;
                throw eof;
            }
            if (line == PacketLineIn.END) break;
            if (line.startsWith("deepen ")) {
                int depth = Integer.parseInt(line.substring(7));
                if (depth <= 0) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidDepth, depth));
                }
                reqBuilder.setDepth(depth);
                continue;
            }
            if (line.startsWith("shallow ")) {
                reqBuilder.addClientShallowCommit(ObjectId.fromString(line.substring(8)));
                continue;
            }
            if (this.transferConfig.isAllowFilter() && line.startsWith("filter ")) {
                String arg = line.substring("filter".length() + 1);
                if (filterReceived) {
                    throw new PackProtocolException(JGitText.get().tooManyFilters);
                }
                filterReceived = true;
                reqBuilder.setFilterBlobLimit(ProtocolV2Parser.filterLine(arg));
                continue;
            }
            if (!line.startsWith("want ") || line.length() < 45) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "want", line));
            }
            if (isFirst && line.length() > 45) {
                FirstWant firstLine = FirstWant.fromLine(line);
                reqBuilder.addClientCapabilities(firstLine.getCapabilities());
                reqBuilder.setAgent(firstLine.getAgent());
                line = firstLine.getLine();
            }
            reqBuilder.addWantId(ObjectId.fromString(line.substring(5)));
            isFirst = false;
        }
        return reqBuilder.build();
    }
}

