/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test.explorer;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.explorer.LaunchOption;
import org.eclipse.wst.ws.internal.explorer.WSExplorerLauncherCommand;
import org.eclipse.wst.ws.internal.explorer.plugin.ExplorerPlugin;
import org.eclipse.wst.ws.internal.wsrt.TestInfo;

public class WSEGenerateCommand
extends AbstractDataModelOperation {
    private TestInfo testInfo;

    public WSEGenerateCommand(TestInfo testInfo) {
        this.testInfo = testInfo;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        WSExplorerLauncherCommand launchCommand = new WSExplorerLauncherCommand();
        launchCommand.setForceLaunchOutsideIDE(this.testInfo.getExternalBrowser());
        Vector<LaunchOption> launchOptionVector = new Vector<LaunchOption>();
        String stateLocation = ExplorerPlugin.getInstance().getPluginStateLocation();
        String defaultFavoritesLocation = ExplorerPlugin.getInstance().getDefaultFavoritesLocation();
        launchOptionVector.add(new LaunchOption("stateLocation", stateLocation));
        launchOptionVector.add(new LaunchOption("defaultFavoritesLocation", defaultFavoritesLocation));
        launchOptionVector.add(new LaunchOption("wsdl", this.testInfo.getWsdlServiceURL()));
        if (this.testInfo.getEndpoint() != null) {
            Iterator it = this.testInfo.getEndpoint().iterator();
            while (it.hasNext()) {
                launchOptionVector.add(new LaunchOption("webServiceEndpoint", it.next().toString()));
            }
        }
        launchCommand.setLaunchOptions(launchOptionVector.toArray(new LaunchOption[0]));
        launchCommand.setEnvironment(env);
        status = launchCommand.execute(monitor, null);
        return status;
    }
}

