/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import javax.persistence.EntityManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.events.InteractionEventDispatcher;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;

public class UINodeBP {
    private UINodeBP() {
    }

    public static void setFocusAndSelection(ISelection sel, TreeViewer tv) {
        tv.getTree().setFocus();
        tv.setSelection(sel, true);
    }

    public static ISpecTestCasePO getSpecTC(IStructuredSelection structuredSel) {
        IExecTestCasePO execTc = null;
        Object firstElement = structuredSel.getFirstElement();
        if (firstElement instanceof IExecTestCasePO) {
            execTc = (IExecTestCasePO)firstElement;
        } else if (firstElement instanceof TestResultNode) {
            TestResultNode trNode = (TestResultNode)firstElement;
            INodePO nodePO = UINodeBP.getExecFromTestResultNode(trNode);
            if (nodePO instanceof ITestCasePO && !(nodePO instanceof IExecTestCasePO) && (nodePO = NodePM.getNode((Long)GeneralStorage.getInstance().getProject().getId(), (String)nodePO.getGuid())) == null) {
                for (IReusedProjectPO usedProject : GeneralStorage.getInstance().getProject().getUsedProjects()) {
                    nodePO = NodePM.getNode((Long)usedProject.getId(), (String)nodePO.getGuid());
                    if (nodePO != null) break;
                }
            }
            while (!(nodePO instanceof IExecTestCasePO)) {
                if ((trNode = trNode.getParent()) == null) {
                    return null;
                }
                nodePO = UINodeBP.getExecFromTestResultNode(trNode);
            }
            execTc = (IExecTestCasePO)nodePO;
        }
        if (execTc != null) {
            return execTc.getSpecTestCase();
        }
        return null;
    }

    public static ITestSuitePO getSpecTS(IStructuredSelection structuredSel) {
        Object firstElement = structuredSel.getFirstElement();
        if (firstElement instanceof TestResultNode) {
            TestResultNode trNode = (TestResultNode)firstElement;
            INodePO nodePO = trNode.getNode();
            if (nodePO instanceof ITestSuitePO) {
                return (ITestSuitePO)NodePM.getNode((Long)GeneralStorage.getInstance().getProject().getId(), (String)nodePO.getGuid());
            }
        } else if (firstElement instanceof ITestSuitePO) {
            return (ITestSuitePO)firstElement;
        }
        return null;
    }

    public static INodePO selectNodeInTree(Long id, TreeViewer tv, EntityManager em) {
        return (INodePO)UINodeBP.selectNodeInTree(em.find(NodeMaker.getNodePOClass(), (Object)id), (AbstractTreeViewer)tv);
    }

    public static Object selectNodeInTree(Object o, AbstractTreeViewer tv) {
        ISelection oldSelection = tv.getSelection();
        if (o != null) {
            tv.refresh();
            tv.expandToLevel(o, 0);
            tv.reveal(o);
            StructuredSelection newSelection = new StructuredSelection(o);
            tv.setSelection((ISelection)newSelection);
            InteractionEventDispatcher.getDefault().fireProgammableSelectionEvent((IStructuredSelection)newSelection);
            ISelection currSelection = tv.getSelection();
            if (currSelection instanceof StructuredSelection) {
                Object currObj = ((StructuredSelection)currSelection).getFirstElement();
                IElementComparer comparer = tv.getComparer();
                if (comparer != null ? comparer.equals(o, currObj) : o.equals(currObj)) {
                    return o;
                }
            }
        }
        tv.setSelection(oldSelection);
        return null;
    }

    public static INodePO getExecFromTestResultNode(TestResultNode trNode) {
        INodePO nodePO = trNode.getNode();
        String guid = nodePO.getGuid();
        if (nodePO instanceof ITestCasePO && nodePO.isGenerated() && (nodePO = NodePM.getNode((Long)GeneralStorage.getInstance().getProject().getId(), (String)guid)) == null) {
            for (IReusedProjectPO usedProject : GeneralStorage.getInstance().getProject().getUsedProjects()) {
                nodePO = NodePM.getNode((Long)usedProject.getId(), (String)guid);
                if (nodePO != null) break;
            }
        }
        return nodePO;
    }
}

