/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.CompNameManager;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractNewComponentNameHandler;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;

public class NewComponentNameInViewHandler
extends AbstractNewComponentNameHandler {
    public Object executeImpl(ExecutionEvent event) {
        String newName = this.openDialog();
        try {
            if (newName != null) {
                String compType = ComponentBuilder.getInstance().getCompSystem().getMostAbstractComponent().getType();
                IComponentNamePO cNamePO = CompNameManager.getInstance().createAndPersistCompNamePO(newName, compType, ComponentNamesBP.CompNameCreationContext.OBJECT_MAPPING);
                DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)cNamePO, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.notInEditor);
            }
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleProjectDeletedException();
        }
        return null;
    }
}

