/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.ui.rcp.search.SearchResultPage;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;

public class SearchPageUtils {
    private SearchPageUtils() {
    }

    public static SearchResultPage getSearchResultPage(ExecutionEvent event) {
        PageBookView pageView;
        IPage currentPage;
        SearchResultPage resultPage = null;
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof PageBookView && (currentPage = (pageView = (PageBookView)activePart).getCurrentPage()) instanceof SearchResultPage) {
            resultPage = (SearchResultPage)currentPage;
        }
        return resultPage;
    }

    public static void selectTestCases(SearchResultPage page, List<BasicSearchResult.SearchResultElement> oldSelection, List<ITestCasePO> testCases) {
        ArrayList<BasicSearchResult.SearchResultElement> newSelection = new ArrayList<BasicSearchResult.SearchResultElement>();
        for (BasicSearchResult.SearchResultElement resultElement : oldSelection) {
            if (!(resultElement.getData() instanceof Long) || !SearchPageUtils.testCasesContainId(testCases, (Long)resultElement.getData())) continue;
            newSelection.add(resultElement);
        }
        page.setSelection((ISelection)new StructuredSelection(newSelection));
    }

    private static boolean testCasesContainId(List<ITestCasePO> testCases, Long id) {
        for (ITestCasePO tc : testCases) {
            if (!id.equals(tc.getId())) continue;
            return true;
        }
        return false;
    }
}

