/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.bpmn.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jwt.transformations.api.TransformationException;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.drivers.emf4atl.AtlEMFModelHandler;
import org.eclipse.m2m.atl.engine.vm.AtlLauncher;
import org.eclipse.m2m.atl.engine.vm.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.ModelLoader;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATLTransformation {
    private static ATLTransformation instance = null;
    private static final String resourcePath = "/org/eclipse/jwt/transformations/bpmn/internal/resources/";
    private AtlEMFModelHandler modelHandler;
    private InputStream JWT_ModelResource;
    private InputStream BPMN_ModelResource;
    private URL BPMN2JWT_TransfoResource;
    private ASMEMFModel xmlMetamodel;
    private ASMEMFModel jwtMetamodel;
    private ASMEMFModel bpmnMetamodel;
    private URL JWT2BPMN_Pool_TransfoResource;
    private ModelLoader modelLoader;

    public static ATLTransformation getInstance() {
        if (instance == null) {
            instance = new ATLTransformation();
        }
        return instance;
    }

    private void createResources() throws TransformationException {
        if (this.BPMN_ModelResource == null || this.BPMN2JWT_TransfoResource == null || this.JWT2BPMN_Pool_TransfoResource == null) {
            this.modelHandler = (AtlEMFModelHandler)AtlModelHandler.getDefault((String)"EMF");
            this.modelLoader = this.modelHandler.createModelLoader();
            String mm_path = "/org/eclipse/jwt/meta/ecore/JWTMetaModel.ecore";
            this.JWT_ModelResource = this.getClass().getResourceAsStream(mm_path);
            this.BPMN_ModelResource = this.getClass().getResourceAsStream("/org/eclipse/jwt/transformations/bpmn/internal/resources/bpmn.ecore");
            this.JWT2BPMN_Pool_TransfoResource = ATLTransformation.class.getResource("/org/eclipse/jwt/transformations/bpmn/internal/resources/Jwt2BpmnAllInPool.asm");
            this.BPMN2JWT_TransfoResource = ATLTransformation.class.getResource("/org/eclipse/jwt/transformations/bpmn/internal/resources/BPMN2JWT.asm");
            if (this.JWT2BPMN_Pool_TransfoResource == null) {
                this.JWT2BPMN_Pool_TransfoResource = this.getClass().getResource("/org/eclipse/jwt/transformations/bpmn/internal/resources/Jwt2BpmnAllInPool.asm");
            }
            if (this.JWT2BPMN_Pool_TransfoResource == null) {
                throw new TransformationException("JWT2BPMN_Pool_TransfoResource is null");
            }
            if (this.BPMN2JWT_TransfoResource == null) {
                this.BPMN2JWT_TransfoResource = this.getClass().getResource("/org/eclipse/jwt/transformations/bpmn/internal/resources/BPMN2JWT.asm");
            }
            if (this.BPMN2JWT_TransfoResource == null) {
                throw new TransformationException("BPMN2JWT_TransfoResource is null");
            }
            try {
                this.BPMN2JWT_TransfoResource.openStream().close();
            }
            catch (Exception ex) {
                throw new TransformationException("error opening transformation resource stream", (Throwable)ex);
            }
        }
    }

    private Map<String, Object> getMetamodels() throws TransformationException {
        HashMap<String, Object> models = new HashMap<String, Object>();
        if (this.jwtMetamodel == null) {
            try {
                this.createResources();
                this.jwtMetamodel = (ASMEMFModel)this.modelLoader.loadModel("jwt", this.modelLoader.getMOF(), this.JWT_ModelResource);
                this.bpmnMetamodel = (ASMEMFModel)this.modelLoader.loadModel("bpmn", this.modelLoader.getMOF(), this.BPMN_ModelResource);
            }
            catch (IOException ex) {
                throw new TransformationException(ex.getMessage(), (Throwable)ex);
            }
        }
        models.put("jwt", this.jwtMetamodel);
        models.put("bpmn", this.bpmnMetamodel);
        return models;
    }

    public void jwt2bpmn(String inFilePath, String outFilePath) throws TransformationException, FileNotFoundException, IOException {
        Map<String, Object> models = this.getMetamodels();
        ASMEMFModel jwtInputModel = (ASMEMFModel)this.modelLoader.loadModel("IN", (ASMModel)this.jwtMetamodel, (InputStream)new FileInputStream(inFilePath));
        ASMEMFModel bpmnOutputModel = (ASMEMFModel)this.modelLoader.newModel("OUT", URI.createFileURI((String)outFilePath).toString(), (ASMModel)this.bpmnMetamodel);
        models.put("IN", jwtInputModel);
        models.put("OUT", bpmnOutputModel);
        if (this.BPMN2JWT_TransfoResource == null) {
            throw new MalformedURLException("transformation resource is null");
        }
        AtlLauncher.getDefault().launch(this.JWT2BPMN_Pool_TransfoResource, Collections.EMPTY_MAP, models, Collections.EMPTY_MAP, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
        this.modelLoader.save((ASMModel)bpmnOutputModel, new File(outFilePath).toURI().toURL().toString());
    }

    public void bpmn2jwt(String inFilePath, String outFilePath) throws TransformationException, MalformedURLException, IOException {
        Map<String, Object> models = this.getMetamodels();
        ASMEMFModel bpmnInputModel = (ASMEMFModel)this.modelLoader.loadModel("IN", (ASMModel)this.bpmnMetamodel, (InputStream)new FileInputStream(inFilePath));
        ASMEMFModel jwtOutputModel = (ASMEMFModel)this.modelLoader.newModel("OUT", URI.createFileURI((String)outFilePath).toString(), (ASMModel)this.jwtMetamodel);
        models.put("IN", bpmnInputModel);
        models.put("OUT", jwtOutputModel);
        if (this.BPMN2JWT_TransfoResource == null) {
            throw new MalformedURLException("transformation resource is null");
        }
        AtlLauncher.getDefault().launch(this.BPMN2JWT_TransfoResource, Collections.EMPTY_MAP, models, Collections.EMPTY_MAP, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
        this.modelLoader.save((ASMModel)jwtOutputModel, new File(outFilePath).toURI().toURL().toString());
    }
}

