/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.plugins.viewepc.figures.organisations;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.swt.graphics.Color;

public class RoleBorder
extends LineBorder {
    public RoleBorder() {
        super(PreferenceReader.appearanceBorderColor.get(), PreferenceReader.appearanceLineWidth.get());
    }

    public Insets getInsets(IFigure figure) {
        Dimension bounds = figure.getSize();
        int i = (int)Math.ceil((double)bounds.width / 2.0 - (double)(bounds.width - this.getWidth()) / 4.0 * Math.sqrt(2.0));
        return new Insets(i);
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        tempRect.setBounds(RoleBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        if (this.getWidth() % 2 == 1) {
            --RoleBorder.tempRect.width;
            --RoleBorder.tempRect.height;
        }
        tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
        graphics.setLineWidth(this.getWidth());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        if (PreferenceReader.appearanceShadowVisible.get()) {
            RoleBorder.tempRect.height -= 4;
            RoleBorder.tempRect.width -= 4;
            RoleBorder.tempRect.x += 2;
            RoleBorder.tempRect.y += 2;
            Rectangle shadowRectangle = new Rectangle(tempRect);
            shadowRectangle.x += 3;
            shadowRectangle.y += 3;
            graphics.setAlpha(50);
            graphics.setBackgroundColor(PreferenceReader.appearanceShadowColor.get());
            graphics.fillOval(shadowRectangle);
            graphics.setAlpha(255);
            graphics.setBackgroundColor(figure.getBackgroundColor());
            ++RoleBorder.tempRect.width;
            ++RoleBorder.tempRect.height;
            graphics.fillOval(tempRect);
            --RoleBorder.tempRect.width;
            --RoleBorder.tempRect.height;
        }
        graphics.setAlpha(50);
        graphics.setBackgroundColor(new Color(null, 255, 215, 10));
        graphics.fillOval(tempRect);
        graphics.setBackgroundColor(PreferenceReader.appearanceBorderColor.get());
        graphics.drawOval(tempRect);
        int xb = RoleBorder.tempRect.x + RoleBorder.tempRect.width / 7;
        int dy = RoleBorder.tempRect.height / 7;
        int yb1 = RoleBorder.tempRect.y + dy;
        int yb2 = RoleBorder.tempRect.y + RoleBorder.tempRect.height - dy;
        Point lineTop = new Point(xb, yb1);
        Point lineBottom = new Point(xb, yb2);
        graphics.drawLine(lineTop, lineBottom);
    }
}

