/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.core.internal.ast.models.api;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.ldt.core.internal.ast.models.api.Item;
import org.eclipse.ldt.core.internal.ast.models.api.Return;
import org.eclipse.ldt.core.internal.ast.models.api.TypeDef;
import org.eclipse.ldt.core.internal.ast.models.common.LuaASTNode;

public class LuaFileAPI
extends LuaASTNode {
    private String documentation;
    private HashMap<String, TypeDef> types = new HashMap();
    private HashMap<String, Item> globalvars = new HashMap();
    private ArrayList<Return> returns = new ArrayList();

    public void addType(String typeName, TypeDef type) {
        this.types.put(typeName, type);
        type.setParent(this);
    }

    public void addGlobalVar(Item item) {
        this.globalvars.put(item.getName(), item);
        item.setParent(this);
    }

    public void addReturns(Return returnValue) {
        this.returns.add(returnValue);
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public HashMap<String, TypeDef> getTypes() {
        return this.types;
    }

    public HashMap<String, Item> getGlobalvars() {
        return this.globalvars;
    }

    public ArrayList<Return> getReturns() {
        return this.returns;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            for (TypeDef typedef : this.types.values()) {
                typedef.traverse(visitor);
            }
            for (Item globalvar : this.globalvars.values()) {
                globalvar.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }
}

