/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandMessages;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRemoveTag;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemoveTagCommandHandler
extends AbstractHandler {
    private static final String REMOVE_TAG_JOB_TITLE = "ImageRemoveTagTitle.msg";
    private static final String REMOVE_TAG_MSG = "ImageRemoveTag.msg";
    private static final String ERROR_REMOVING_TAG_IMAGE = "ImageRemoveTagError.msg";

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        List<IDockerImage> selectedImages = CommandUtils.getSelectedImages(activePart);
        IDockerConnection connection = CommandUtils.getCurrentConnection(activePart);
        if (selectedImages.size() != 1 || connection == null) {
            Activator.log(new DockerException(CommandMessages.getString("Command.missing.selection.failure")));
            return null;
        }
        IDockerImage image = selectedImages.get(0);
        ImageRemoveTag wizard = new ImageRemoveTag(image);
        boolean removeTag = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (removeTag) {
            this.performRemoveTagImage(connection, wizard.getTag());
        }
        return null;
    }

    private void performRemoveTagImage(final IDockerConnection connection, final String tag) {
        Job removeTagImageJob = new Job(DVMessages.getString(REMOVE_TAG_JOB_TITLE)){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(DVMessages.getString(RemoveTagCommandHandler.REMOVE_TAG_MSG), 2);
                try {
                    try {
                        ((DockerConnection)connection).removeTag(tag);
                        monitor.worked(1);
                        ((DockerConnection)connection).getImages(true);
                        monitor.worked(1);
                    }
                    catch (DockerException e) {
                        Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getFormattedString(RemoveTagCommandHandler.ERROR_REMOVING_TAG_IMAGE, tag), (String)e.getMessage()));
                        monitor.done();
                    }
                    catch (InterruptedException interruptedException) {
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        removeTagImageJob.schedule();
    }
}

