/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.docker.core.IRegistryAccount;
import org.eclipse.linuxtools.internal.docker.core.RegistryAccountManager;
import org.eclipse.linuxtools.internal.docker.ui.wizards.RegistryAccountDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DockerRegistryAccountPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    public static final String ACCOUNT_PREFERENCE_PAGE_ID = "org.eclipse.linuxtools.docker.ui.preferences.DockerRegistryAccountPreferencePage";
    private Table pwdTable;
    private TableViewer pwdTableViewer;
    private PasswordContentProvider provider;
    private Button addButton;
    private Button changeButton;
    private Button removeButton;
    private List<IRegistryAccount> passwords;
    private List<PasswordModification> modifications;

    public DockerRegistryAccountPreferencePage() {
        this.noDefaultAndApplyButton();
        this.provider = new PasswordContentProvider();
        this.modifications = new ArrayList<PasswordModification>();
    }

    public DockerRegistryAccountPreferencePage(String title) {
        super(title);
    }

    public DockerRegistryAccountPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite page = DockerRegistryAccountPreferencePage.createComposite(parent, 1, 2, false, null, -1, -1, 4);
        GridData gd = (GridData)page.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.pwdTable = new Table(page, 68354);
        this.pwdTable.setLinesVisible(true);
        this.pwdTable.setHeaderVisible(true);
        this.pwdTable.addListener(13, (Listener)this);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        this.pwdTable.setLayout((Layout)tableLayout);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.pwdTable.setLayoutData((Object)gd);
        TableColumn hostnameColumn = new TableColumn(this.pwdTable, 0);
        hostnameColumn.setText("Server Address");
        TableColumn sysTypeColumn = new TableColumn(this.pwdTable, 0);
        sysTypeColumn.setText("Username");
        TableColumn useridColumn = new TableColumn(this.pwdTable, 0);
        useridColumn.setText("Email");
        this.pwdTableViewer = new TableViewer(this.pwdTable);
        this.pwdTableViewer.setContentProvider((IContentProvider)this.provider);
        this.pwdTableViewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.pwdTableViewer.setInput(this.passwords);
        Composite buttonBar = DockerRegistryAccountPreferencePage.createComposite(page, 1, 1, false, null, -1, -1, 4);
        gd = (GridData)buttonBar.getLayoutData();
        gd.grabExcessHorizontalSpace = false;
        gd.grabExcessVerticalSpace = true;
        this.addButton = DockerRegistryAccountPreferencePage.createPushButton(buttonBar, this, "Add", "Add a new Docker registry account.");
        this.changeButton = DockerRegistryAccountPreferencePage.createPushButton(buttonBar, this, "Edit", "Edit an existing Docker registry account.");
        this.removeButton = DockerRegistryAccountPreferencePage.createPushButton(buttonBar, this, "Remove", "Remove an existing Docker registry account.");
        this.changeButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        return parent;
    }

    public void init(IWorkbench workbench) {
        this.passwords = new ArrayList<IRegistryAccount>(RegistryAccountManager.getInstance().getAccounts());
        if (this.pwdTableViewer != null) {
            this.pwdTableViewer.refresh();
        }
    }

    public void handleEvent(Event event) {
        if (event.type == 13) {
            if (event.widget == this.addButton) {
                RegistryAccountDialog dialog = new RegistryAccountDialog(this.getShell(), "New Registry Account");
                if (dialog.open() == 0) {
                    IRegistryAccount info = dialog.getSignonInformation();
                    this.passwords.add(info);
                    this.modifications.add(new PasswordModification(1, info));
                    this.pwdTableViewer.refresh();
                    this.pwdTable.select(this.passwords.size() - 1);
                }
            } else if (event.widget == this.changeButton) {
                RegistryAccountDialog dialog = new RegistryAccountDialog(this.getShell(), "Edit Registry Account");
                int index = this.pwdTable.getSelectionIndex();
                IRegistryAccount info = this.passwords.get(index);
                dialog.setInputData(info);
                if (dialog.open() == 0) {
                    info = dialog.getSignonInformation();
                    IRegistryAccount oldInfo = this.passwords.remove(index);
                    this.passwords.add(index, info);
                    this.modifications.add(new PasswordModification(2, oldInfo));
                    this.modifications.add(new PasswordModification(1, info));
                    this.pwdTableViewer.refresh();
                    this.pwdTable.select(index);
                }
            } else if (event.widget == this.removeButton) {
                int[] indicies = this.pwdTable.getSelectionIndices();
                int idx = indicies.length - 1;
                while (idx >= 0) {
                    RegistryAccountManager.getInstance().remove(this.passwords.get(indicies[idx]));
                    this.modifications.add(new PasswordModification(2, this.passwords.remove(indicies[idx])));
                    --idx;
                }
                this.pwdTableViewer.refresh();
            }
            switch (this.pwdTable.getSelectionCount()) {
                case 0: {
                    this.changeButton.setEnabled(false);
                    this.removeButton.setEnabled(false);
                    break;
                }
                case 1: {
                    this.changeButton.setEnabled(true);
                    this.removeButton.setEnabled(true);
                    break;
                }
                default: {
                    this.changeButton.setEnabled(false);
                    this.removeButton.setEnabled(true);
                }
            }
        }
    }

    public boolean performOk() {
        if (this.modifications.size() > 0) {
            RegistryAccountManager manager = RegistryAccountManager.getInstance();
            int i = 0;
            while (i < this.modifications.size()) {
                PasswordModification mod = this.modifications.get(i);
                if (mod.changeFlag == 1) {
                    manager.add(mod.info);
                } else if (mod.changeFlag == 2) {
                    manager.remove(mod.info);
                }
                ++i;
            }
            this.modifications.clear();
        }
        return super.performOk();
    }

    public boolean performCancel() {
        this.modifications.clear();
        return super.performCancel();
    }

    private static Composite createComposite(Composite parent, int parentSpan, int numColumns, boolean border, String label, int marginSize, int spacingSize, int verticalAlignment) {
        boolean borderNeeded = border;
        if (label != null) {
            borderNeeded = true;
        }
        int style = 0;
        if (borderNeeded) {
            style |= 0x10;
        }
        Group composite = null;
        if (borderNeeded) {
            composite = new Group(parent, style);
            if (label != null) {
                composite.setText(label);
            }
        } else {
            composite = new Composite(parent, style);
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        if (marginSize != -1) {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        if (spacingSize != -1) {
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
        }
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalSpan = parentSpan;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = verticalAlignment;
        data.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public static Button createPushButton(Composite group, Listener listener, String label, String tooltip) {
        Button button = new Button(group, 8);
        button.setText(label);
        if (listener != null) {
            button.addListener(13, listener);
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)data);
        if (tooltip != null) {
            button.setToolTipText(tooltip);
        }
        return button;
    }

    private final class PasswordContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private PasswordContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return DockerRegistryAccountPreferencePage.this.passwords.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IRegistryAccount) {
                IRegistryAccount info = (IRegistryAccount)element;
                switch (columnIndex) {
                    case 0: {
                        return info.getServerAddress();
                    }
                    case 1: {
                        return info.getUsername();
                    }
                    case 2: {
                        return info.getEmail();
                    }
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    protected class PasswordModification {
        protected static final int ADD = 1;
        protected static final int DELETE = 2;
        protected int changeFlag;
        protected IRegistryAccount info;

        protected PasswordModification(int changeFlag, IRegistryAccount info) {
            this.changeFlag = changeFlag;
            this.info = info;
        }
    }
}

