/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.model;

import java.text.Collator;
import java.util.Comparator;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelImage;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSample;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSymbol;

public class UiModelSorting
implements Comparator<IUiModelElement> {
    private static UiModelSorting instance = new UiModelSorting();
    private Collator collator = Collator.getInstance();

    private UiModelSorting() {
    }

    public static UiModelSorting getInstance() {
        return instance;
    }

    @Override
    public int compare(IUiModelElement o1, IUiModelElement o2) {
        if (o1 instanceof UiModelSample && o2 instanceof UiModelSample) {
            return ((UiModelSample)o1).getLine() - ((UiModelSample)o2).getLine();
        }
        if (o1 instanceof UiModelSymbol && o2 instanceof UiModelSymbol) {
            return this.collator.compare(((UiModelSymbol)o1).getFunctionName(), ((UiModelSymbol)o2).getFunctionName());
        }
        if (o1 instanceof UiModelImage && o2 instanceof UiModelImage) {
            return this.collator.compare(this.getLibraryName(o1.getLabelText()), this.getLibraryName(o2.getLabelText()));
        }
        return this.collator.compare(o1.getLabelText(), o2.getLabelText());
    }

    private String getLibraryName(String lib) {
        String libName = "";
        int index = 0;
        if (lib != null && lib.trim().length() != 0 && (index = lib.lastIndexOf(47)) != -1) {
            libName = lib.substring(index + 1, lib.length());
        }
        return libName;
    }
}

