/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.commands;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.vagrant.ui.commands.CommandUtils;
import org.eclipse.linuxtools.vagrant.core.IVagrantBox;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class BaseBoxesCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        final List<IVagrantBox> selectedImages = CommandUtils.getSelectedImages(activePart);
        Job job = new Job(this.getJobName(selectedImages)){

            protected IStatus run(IProgressMonitor monitor) {
                if (BaseBoxesCommandHandler.this.confirmed(selectedImages)) {
                    monitor.beginTask(BaseBoxesCommandHandler.this.getJobName(selectedImages), selectedImages.size());
                    for (IVagrantBox image : selectedImages) {
                        monitor.setTaskName(BaseBoxesCommandHandler.this.getTaskName(image));
                        BaseBoxesCommandHandler.this.executeInJob(image, monitor);
                        monitor.worked(1);
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setUser(true);
        job.schedule();
        return null;
    }

    void openError(String errorMessage, Exception e) {
        Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)errorMessage, (String)e.getMessage()));
    }

    boolean confirmed(List<IVagrantBox> selectedImages) {
        return true;
    }

    abstract String getJobName(List<IVagrantBox> var1);

    abstract String getTaskName(IVagrantBox var1);

    abstract void executeInJob(IVagrantBox var1, IProgressMonitor var2);
}

