/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.event.DocumentBuilderEvent;

public class DocumentBuilderEvents {
    private final List<DocumentBuilderEvent> events;

    public DocumentBuilderEvents(List<DocumentBuilderEvent> events) {
        this.events = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(events, (Object)"Must provide events")));
    }

    public List<DocumentBuilderEvent> getEvents() {
        return this.events;
    }

    public void applyTo(DocumentBuilder builder) {
        Preconditions.checkNotNull((Object)builder, (Object)"Must provide a builder");
        for (DocumentBuilderEvent event : this.events) {
            event.invoke(builder);
        }
    }

    public String toString() {
        return MessageFormat.format("{0} [events={1}]", this.events);
    }
}

