/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RoundRobinList<E>
extends LinkedList<E> {
    private static final long serialVersionUID = 1L;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Iterator<E> it;

    public RoundRobinList() {
    }

    public RoundRobinList(Collection<? extends E> c) {
        super(c);
    }

    public void executeReads(Runnable runnable) {
        try {
            this.lock.readLock().lock();
            runnable.run();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void executeWrites(Runnable runnable) {
        try {
            this.lock.writeLock().lock();
            runnable.run();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void add(int index, E element) {
        try {
            this.lock.writeLock().lock();
            super.add(index, element);
            this.it = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean add(E o) {
        try {
            this.lock.writeLock().lock();
            this.it = null;
            boolean bl = super.add(o);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        try {
            this.lock.writeLock().lock();
            this.it = null;
            boolean bl = super.addAll(c);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        try {
            this.lock.writeLock().lock();
            this.it = null;
            boolean bl = super.addAll(index, c);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void addFirst(E o) {
        try {
            this.lock.writeLock().lock();
            this.it = null;
            super.addFirst(o);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void addLast(E o) {
        try {
            this.lock.writeLock().lock();
            this.it = null;
            super.addLast(o);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        try {
            this.lock.writeLock().lock();
            this.it = null;
            super.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Object clone() {
        try {
            this.lock.readLock().lock();
            Object object = super.clone();
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean contains(Object o) {
        try {
            this.lock.readLock().lock();
            boolean bl = super.contains(o);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        try {
            this.lock.readLock().lock();
            boolean bl = super.containsAll(c);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public E element() {
        try {
            this.lock.readLock().lock();
            if (this.isEmpty()) {
                return null;
            }
            if (this.it == null || !this.it.hasNext()) {
                this.it = this.iterator();
            }
            E e = this.it.next();
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public E get(int index) {
        try {
            this.lock.readLock().lock();
            Object e = super.get(index);
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public E getFirst() {
        try {
            this.lock.readLock().lock();
            Object e = super.getFirst();
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public E getLast() {
        try {
            this.lock.readLock().lock();
            Object e = super.getLast();
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int indexOf(Object o) {
        try {
            this.lock.readLock().lock();
            int n = super.indexOf(o);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        try {
            this.lock.readLock().lock();
            int n = super.lastIndexOf(o);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean offer(E o) {
        try {
            this.lock.writeLock().lock();
            this.it = null;
            boolean bl = super.offer(o);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public E peek() {
        try {
            this.lock.readLock().lock();
            Object e = super.peek();
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public E poll() {
        try {
            this.lock.writeLock().lock();
            this.it = null;
            Object e = super.poll();
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public E remove() {
        try {
            this.lock.writeLock().lock();
            this.it = null;
            Object e = super.remove();
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public E remove(int index) {
        try {
            this.lock.writeLock().lock();
            this.it = null;
            Object e = super.remove(index);
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        try {
            this.lock.writeLock().lock();
            this.it = null;
            boolean bl = super.remove(o);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        try {
            this.lock.writeLock().lock();
            this.it = null;
            boolean bl = super.removeAll(c);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public E removeFirst() {
        try {
            this.lock.writeLock().lock();
            this.it = null;
            Object e = super.removeFirst();
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public E removeLast() {
        try {
            this.lock.writeLock().lock();
            this.it = null;
            Object e = super.removeLast();
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        try {
            this.lock.writeLock().lock();
            this.it = null;
            boolean bl = super.retainAll(c);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public E set(int index, E element) {
        try {
            this.lock.writeLock().lock();
            this.it = null;
            E e = super.set(index, element);
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        try {
            this.lock.readLock().lock();
            List list = super.subList(fromIndex, toIndex);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Object[] toArray() {
        try {
            this.lock.readLock().lock();
            Object[] objectArray = super.toArray();
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        try {
            this.lock.readLock().lock();
            T[] TArray = super.toArray(a);
            return TArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

