/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import java.util.Arrays;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IRandomizer;
import org.eclipse.net4j.util.security.IUserManager;
import org.eclipse.net4j.util.security.Randomizer;
import org.eclipse.net4j.util.security.SecurityUtil;

public class UserManagerAuthenticator
extends Lifecycle
implements IAuthenticator {
    public static final int DEFAULT_TOKEN_LENGTH = 1024;
    @ReflectUtil.ExcludeFromDump
    private String encryptionAlgorithmName = "PBEWithMD5AndDES";
    @ReflectUtil.ExcludeFromDump
    private byte[] encryptionSaltBytes = SecurityUtil.DEFAULT_SALT;
    @ReflectUtil.ExcludeFromDump
    private int encryptionIterationCount = 20;
    private int tokenLength = 1024;
    private IRandomizer randomizer;
    private IUserManager userManager;

    public String getEncryptionAlgorithmName() {
        return this.encryptionAlgorithmName;
    }

    public void setEncryptionAlgorithmName(String encryptionAlgorithmName) {
        this.checkInactive();
        this.encryptionAlgorithmName = encryptionAlgorithmName;
    }

    public byte[] getEncryptionSaltBytes() {
        return this.encryptionSaltBytes;
    }

    public void setEncryptionSaltBytes(byte[] encryptionSaltBytes) {
        this.checkInactive();
        this.encryptionSaltBytes = encryptionSaltBytes;
    }

    public int getEncryptionIterationCount() {
        return this.encryptionIterationCount;
    }

    public void setEncryptionIterationCount(int encryptionIterationCount) {
        this.checkInactive();
        this.encryptionIterationCount = encryptionIterationCount;
    }

    public int getTokenLength() {
        return this.tokenLength;
    }

    public void setTokenLength(int tokenLength) {
        this.checkInactive();
        this.tokenLength = tokenLength;
    }

    public IRandomizer getRandomizer() {
        return this.randomizer;
    }

    public void setRandomizer(IRandomizer randomizer) {
        this.checkInactive();
        this.randomizer = randomizer;
    }

    public IUserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(IUserManager userManager) {
        this.checkInactive();
        this.userManager = userManager;
    }

    public void authenticate(String userID, char[] password) throws SecurityException {
        try {
            byte[] randomToken = this.createRandomToken();
            byte[] cryptedTokenClient = SecurityUtil.encrypt(randomToken, password, this.encryptionAlgorithmName, this.encryptionSaltBytes, this.encryptionIterationCount);
            byte[] cryptedTokenServer = this.userManager.encrypt(userID, randomToken, this.encryptionAlgorithmName, this.encryptionSaltBytes, this.encryptionIterationCount);
            if (!Arrays.equals(cryptedTokenClient, cryptedTokenServer)) {
                throw new SecurityException("Access denied");
            }
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SecurityException) {
                throw (SecurityException)cause;
            }
            throw new SecurityException(ex);
        }
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.userManager, "userManager");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (this.randomizer == null) {
            this.randomizer = new Randomizer();
        }
        LifecycleUtil.activate(this.randomizer);
    }

    protected byte[] createRandomToken() {
        byte[] token = new byte[this.tokenLength];
        this.randomizer.nextBytes(token);
        return token;
    }
}

