/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode;

import java.lang.instrument.IllegalClassFormatException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.objectteams.otredyn.bytecode.ClassRepository;
import org.eclipse.objectteams.otredyn.bytecode.Field;
import org.eclipse.objectteams.otredyn.bytecode.Member;
import org.eclipse.objectteams.otredyn.bytecode.Method;
import org.eclipse.objectteams.otredyn.runtime.ClassIdentifierProviderFactory;
import org.eclipse.objectteams.otredyn.runtime.IBinding;
import org.eclipse.objectteams.otredyn.runtime.IBoundClass;
import org.eclipse.objectteams.otredyn.runtime.IMethod;
import org.eclipse.objectteams.otredyn.runtime.ISubclassWiringTask;
import org.eclipse.objectteams.otredyn.runtime.TeamManager;
import org.eclipse.objectteams.otredyn.transformer.IWeavingContext;
import org.eclipse.objectteams.runtime.IReweavingTask;

public abstract class AbstractBoundClass
implements IBoundClass {
    private Map<Method, WeavingTask> completedBindingTasks;
    public Map<Method, WeavingTask> openBindingTasks;
    private Map<Member, WeavingTask> completedAccessTasks;
    private Map<Member, WeavingTask> openAccessTasks;
    private List<ISubclassWiringTask> wiringTasks;
    protected int transactionCount;
    protected boolean parsed;
    private String name;
    private String internalName;
    private String id;
    private String superClassName;
    private String internalSuperClassName;
    private String[] internalSuperInterfaces;
    private AbstractBoundClass superclass;
    private AbstractBoundClass enclosingClass;
    private Map<String, Method> methods;
    private Map<String, Field> fields;
    protected Map<AbstractBoundClass, Object> subclasses;
    private boolean isLoaded;
    protected boolean isUnweavable;
    protected boolean hierarchyIsCallinAffected = false;
    private int modifiers;
    private int otClassFlags;
    private boolean implicitTeamActivationEnabled = false;
    private Set<String> methodsForImplicitActivation;
    protected ClassLoader loader;
    protected IWeavingContext weavingContext;

    protected AbstractBoundClass(String name, String id, ClassLoader loader) {
        this.name = name;
        this.internalName = name.replace('.', '/');
        this.id = id;
        this.loader = loader;
        this.completedBindingTasks = new IdentityHashMap<Method, WeavingTask>();
        this.openBindingTasks = new IdentityHashMap<Method, WeavingTask>();
        this.openAccessTasks = new IdentityHashMap<Member, WeavingTask>();
        this.completedAccessTasks = new IdentityHashMap<Member, WeavingTask>();
        this.methods = new HashMap<String, Method>();
        this.fields = new HashMap<String, Field>();
        this.subclasses = new IdentityHashMap<AbstractBoundClass, Object>();
        if (!name.equals("AnonymousSubclass")) {
            AbstractBoundClass anonymousSubclass = ClassRepository.getInstance().getAnonymousSubclass(this);
            this.subclasses.put(anonymousSubclass, null);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean isAnonymous() {
        return this.getName().equals("AnonymousSubclass");
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void setSuperClassName(String superClassName) {
        if (superClassName == null) {
            return;
        }
        this.superClassName = superClassName.replace('/', '.');
        this.internalSuperClassName = superClassName.replace('.', '/');
    }

    public void setSuperInterfaces(String[] interfaces) {
        if (interfaces == null) {
            return;
        }
        this.internalSuperInterfaces = interfaces;
    }

    public boolean isJavaLangObject() {
        return this.name.equals("java.lang.Object");
    }

    public boolean isInterface() {
        this.parseBytecode();
        return (this.modifiers & 0x200) != 0;
    }

    public boolean isTeam() {
        this.parseBytecode();
        return (this.otClassFlags & 1) != 0;
    }

    public int nestingDepth() {
        this.parseBytecode();
        if ((this.modifiers & 8) != 0) {
            return 0;
        }
        if (this.enclosingClass != null) {
            return this.enclosingClass.nestingDepth() + 1;
        }
        return 0;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setOTClassFlags(int flags) {
        this.otClassFlags = flags;
    }

    public boolean isRole() {
        return (this.otClassFlags & 2) != 0;
    }

    public boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public void enableImplicitActivation() {
        this.implicitTeamActivationEnabled = true;
    }

    public void registerMethodForImplicitActivation(String methodNameAndDesc) {
        if (this.methodsForImplicitActivation == null) {
            this.methodsForImplicitActivation = new HashSet<String>();
        }
        this.methodsForImplicitActivation.add(methodNameAndDesc);
    }

    public boolean hasMethodImplicitActivation(String methodNameAndDesc, boolean methodIsAccessible) {
        if (this.implicitTeamActivationEnabled && methodIsAccessible) {
            return true;
        }
        if (this.methodsForImplicitActivation == null) {
            return false;
        }
        return this.methodsForImplicitActivation.contains(methodNameAndDesc);
    }

    public void setWeavingContext(IWeavingContext weavingContext) {
        this.weavingContext = weavingContext;
    }

    public void transformAtLoadTime() throws IllegalClassFormatException {
        this.handleTaskList(null);
    }

    public void setLoaded() {
        this.isLoaded = true;
    }

    public synchronized AbstractBoundClass getSuperclass() {
        String superclassId;
        this.parseBytecode();
        if (this.superClassName != null && this.superclass == null && (superclassId = ClassIdentifierProviderFactory.getClassIdentifierProvider().getSuperclassIdentifier(this.id, this.internalSuperClassName)) != null) {
            this.superclass = ClassRepository.getInstance().getBoundClass(this.superClassName, superclassId, this.loader);
            this.superclass.addSubclass(this);
        }
        return this.superclass;
    }

    public String[] getSuperInterfaceNames() {
        this.parseBytecode();
        return this.internalSuperInterfaces;
    }

    public synchronized AbstractBoundClass getEnclosingClass() {
        this.parseBytecode();
        int pos = this.internalName.lastIndexOf(36);
        if (pos != -1) {
            String enclosingClassName = this.internalName.substring(0, pos);
            String enclosingClassID = ClassIdentifierProviderFactory.getClassIdentifierProvider().getSuperclassIdentifier(this.id, enclosingClassName);
            if (enclosingClassID != null) {
                this.enclosingClass = ClassRepository.getInstance().getBoundClass(enclosingClassName, enclosingClassID, this.loader);
                this.enclosingClass.addSubclass(this);
            }
        }
        return this.enclosingClass;
    }

    public synchronized String getEnclosingClassName() {
        this.parseBytecode();
        int pos = this.internalName.lastIndexOf(36);
        if (pos != -1) {
            return this.internalName.substring(0, pos);
        }
        return null;
    }

    public abstract void parseBytecode();

    public String getInternalSuperClassName() {
        this.parseBytecode();
        return this.internalSuperClassName;
    }

    public String getInternalWeavableSuperClassName(boolean considerSupers) {
        if (!this.isSuperWeavable(considerSupers)) {
            return null;
        }
        this.parseBytecode();
        return this.internalSuperClassName;
    }

    protected abstract boolean isSuperWeavable(boolean var1);

    public String getInternalName() {
        return this.internalName;
    }

    public String getSuperClassName() {
        this.parseBytecode();
        return this.superClassName;
    }

    public void addMethod(String name, String desc, boolean isStatic, int accessFlags) {
        if (desc == null) {
            System.err.println("OTDRE: Method " + name + " in class " + this.name + " has no descriptor");
            return;
        }
        String methodKey = this.getMethodKey(name, desc);
        Method method = this.methods.get(methodKey);
        if (method == null) {
            method = new Method(name, desc, isStatic, accessFlags);
            method.setImplemented(true);
            this.methods.put(methodKey, method);
        } else {
            method.setImplemented(true);
            method.setStatic(isStatic);
        }
    }

    private String getMethodKey(String name, String desc) {
        int pos = desc.indexOf(41);
        return String.valueOf(name) + desc.substring(0, pos + 1);
    }

    public void addField(String name, String desc, boolean isStatic, int accessFlags) {
        Field field = this.fields.get(name);
        if (field == null) {
            field = new Field(name, desc, isStatic, accessFlags);
            this.fields.put(name, field);
        } else {
            field.setStatic(isStatic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getMethod(String name, String desc, int flags, boolean allowCovariantReturn) {
        String methodKey;
        Method method;
        if (this.parsed && (method = this.methods.get(methodKey = this.getMethodKey(name, desc))) != null) {
            if (allowCovariantReturn || method.getSignature().equals(desc)) {
                return method;
            }
            return null;
        }
        AbstractBoundClass abstractBoundClass = this;
        synchronized (abstractBoundClass) {
            Method method2;
            String methodKey2;
            block10: {
                this.parseBytecode();
                methodKey2 = this.getMethodKey(name, desc);
                method2 = this.methods.get(methodKey2);
                if (allowCovariantReturn || method2 == null || method2.getSignature().equals(desc)) break block10;
                return null;
            }
            if (method2 == null) {
                int access = 0;
                if ((flags & 8) != 0) {
                    access |= 2;
                } else if ((flags & 0x10) != 0) {
                    access |= 1;
                }
                method2 = new Method(name, desc, (flags & 2) != 0, access);
                this.methods.put(methodKey2, method2);
            }
            return method2;
        }
    }

    Method getMethod(WeavingTask task) {
        return this.getMethod(task.getMemberName(), task.getMemberSignature(), task.getBaseFlags(), task.isHandleCovariantReturn());
    }

    Method getMethod(Method method, WeavingTask task) {
        return this.getMethod(method.getName(), method.getSignature(), task.getBaseFlags(), task.isHandleCovariantReturn());
    }

    public synchronized Method getMethod(String name, String desc, boolean allowCovariantReturn, boolean isStatic) {
        this.parseBytecode();
        String methodKey = this.getMethodKey(name, desc);
        Method method = this.methods.get(methodKey);
        if (!allowCovariantReturn && method != null && !method.getSignature().equals(desc)) {
            method = null;
        }
        if (method == null) {
            method = new Method(name, desc);
            method.setStatic(isStatic);
            this.methods.put(methodKey, method);
        }
        boolean actualStatic = method.isStatic();
        if (name.equals("<init>")) {
            actualStatic = true;
        }
        assert (actualStatic == isStatic) : "Mismatching static/non-static methods " + this.getName() + '.' + name + desc;
        return method;
    }

    public synchronized Field getField(String name, String desc) {
        this.parseBytecode();
        Field field = this.fields.get(name);
        if (field == null) {
            field = new Field(name, desc);
            this.fields.put(name, field);
        }
        return field;
    }

    public String getMethodIdentifier(IMethod method) {
        String signature = method.getSignature();
        int close = signature.lastIndexOf(41);
        return String.valueOf(this.getId()) + '.' + method.getName() + signature.substring(0, close + 1);
    }

    protected void addSubclass(AbstractBoundClass subclass) {
        this.subclasses.put(subclass, null);
    }

    protected void removeSubclass(AbstractBoundClass subclass) {
        this.subclasses.remove(subclass);
    }

    private Collection<AbstractBoundClass> getSubclasses() {
        return new ArrayList<AbstractBoundClass>(this.subclasses.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTaskList(Class<?> definedClass) throws IllegalClassFormatException {
        if (this.isTransformationActive()) {
            return;
        }
        if (this.isUnweavable) {
            new LinkageError("Class " + this.name + " is requested to be woven, but it is marked as unweavable.").printStackTrace();
        }
        AbstractBoundClass abstractBoundClass = this;
        synchronized (abstractBoundClass) {
            boolean firstIteration = true;
            while (true) {
                WeavingTask newTask;
                Object task;
                Set<Map.Entry<Member, WeavingTask>> accessEntrySet;
                Set<Map.Entry<Method, WeavingTask>> bindingEntrySet;
                boolean processingOpenTasks = false;
                Map<Method, WeavingTask> map = this.openBindingTasks;
                synchronized (map) {
                    bindingEntrySet = this.copyEntrySet(this.openBindingTasks);
                    accessEntrySet = this.copyEntrySet(this.openAccessTasks);
                    boolean bl = processingOpenTasks = !this.openBindingTasks.isEmpty() || !this.openAccessTasks.isEmpty();
                    if (processingOpenTasks) {
                        this.openBindingTasks.clear();
                        this.openAccessTasks.clear();
                    } else if (!firstIteration) {
                        break;
                    }
                }
                firstIteration = false;
                if (bindingEntrySet.size() > 0 || accessEntrySet.size() > 0) {
                    this.startTransformation();
                    this.parseBytecode();
                    this.prepareAsPossibleBaseClass();
                    this.prepareTeamActivation();
                    this.prepareLiftingParticipant();
                } else if (this.isFirstTransformation()) {
                    this.startTransformation();
                    this.prepareAsPossibleBaseClass();
                    if (this.hierarchyIsCallinAffected()) {
                        this.createSuperCalls();
                    }
                    this.prepareTeamActivation();
                    this.prepareLiftingParticipant();
                    this.endTransformation(definedClass);
                }
                HashSet<AbstractBoundClass> affectedClasses = new HashSet<AbstractBoundClass>();
                for (Map.Entry<Method, WeavingTask> entry : bindingEntrySet) {
                    task = entry.getValue();
                    Method method = entry.getKey();
                    switch (((WeavingTask)task).getType()) {
                        case WEAVE_BINDING_OF_SUBCLASS: {
                            if (method.isImplemented()) {
                                this.weaveBindingOfSubclass((WeavingTask)task);
                                break;
                            }
                            AbstractBoundClass superclass = this.getSuperclass();
                            if (superclass == null) break;
                            superclass.addWeavingTask((WeavingTask)task, true);
                            affectedClasses.add(superclass);
                            this.weaveSuperCallInCallOrig((WeavingTask)task);
                            break;
                        }
                        case WEAVE_BINDING: {
                            Object subMethod;
                            AbstractBoundClass subclass;
                            Object superMethod;
                            AbstractBoundClass superclass;
                            if (method.isStatic()) {
                                this.weaveBindingInStaticMethod((WeavingTask)task);
                                break;
                            }
                            if (method.isImplemented()) {
                                this.weaveBindingInImplementedMethod((WeavingTask)task);
                                if (!method.isStatic() && this.weavingContext.isWeavable(this.getSuperClassName(), false, false) && ((Method)(superMethod = (superclass = this.getSuperclass()).getMethod(method.getName(), method.getSignature(), true, false))).isImplemented()) {
                                    this.replaceWickedSuperCalls(this.getSuperclass(), method);
                                }
                            } else {
                                this.weaveBindingInNotImplementedMethod((WeavingTask)task, true);
                                superclass = this.getSuperclass();
                                while (superclass != null && !superclass.isJavaLangObject()) {
                                    if (this.weavingContext.isWeavable(superclass.getName(), false, false) && (superMethod = superclass.getMethod(method, (WeavingTask)task)) != null) {
                                        WeavingTask newTask2 = new WeavingTask(WeavingTaskType.WEAVE_BINDING_OF_SUBCLASS, (Method)superMethod, (WeavingTask)task, null);
                                        superclass.addWeavingTask(newTask2, true);
                                        affectedClasses.add(superclass);
                                        break;
                                    }
                                    superclass = superclass.getSuperclass();
                                }
                            }
                            superMethod = this.getSubclasses().iterator();
                            while (superMethod.hasNext()) {
                                subclass = superMethod.next();
                                subMethod = subclass.getMethod(method, (WeavingTask)task);
                                if (subMethod == null) continue;
                                newTask = new WeavingTask(WeavingTaskType.WEAVE_INHERITED_BINDING, (Method)subMethod, (WeavingTask)task, this);
                                subclass.addWeavingTask(newTask, true);
                                affectedClasses.add(subclass);
                                TeamManager.mergeJoinpoints((IBoundClass)this, (IBoundClass)subclass, (IMethod)method, (IMethod)subMethod, (boolean)((WeavingTask)task).isHandleCovariantReturn());
                            }
                            break;
                        }
                        case WEAVE_INHERITED_BINDING: {
                            Object subMethod;
                            AbstractBoundClass subclass;
                            if (method.isImplemented()) {
                                this.weaveBindingInImplementedMethod((WeavingTask)task);
                                if (!method.isStatic()) {
                                    this.replaceWickedSuperCalls(this.getSuperclass(), method);
                                }
                            } else {
                                this.weaveBindingInNotImplementedMethod((WeavingTask)task, false);
                            }
                            Object superMethod = this.getSubclasses().iterator();
                            while (superMethod.hasNext()) {
                                subclass = superMethod.next();
                                subMethod = subclass.getMethod(method, (WeavingTask)task);
                                newTask = new WeavingTask(WeavingTaskType.WEAVE_INHERITED_BINDING, (Method)subMethod, (WeavingTask)task, this);
                                subclass.addWeavingTask(newTask, true);
                                affectedClasses.add(subclass);
                                TeamManager.mergeJoinpoints((IBoundClass)this, (IBoundClass)subclass, (IMethod)method, (IMethod)subMethod, (boolean)((WeavingTask)task).isHandleCovariantReturn());
                            }
                            break;
                        }
                    }
                    this.completedBindingTasks.put(method, (WeavingTask)task);
                }
                for (Map.Entry<Member, WeavingTask> entry : accessEntrySet) {
                    task = entry.getValue();
                    Member member = entry.getKey();
                    switch (((WeavingTask)task).getType()) {
                        case WEAVE_FIELD_ACCESS: {
                            this.prepareForFirstMemberAccess();
                            Field field = this.getField(((WeavingTask)task).getMemberName(), ((WeavingTask)task).getMemberSignature());
                            this.weaveFieldAccess(field, field.getGlobalId(this));
                            if (field.isStatic()) break;
                            for (AbstractBoundClass subclass : this.getSubclasses()) {
                                newTask = new WeavingTask(WeavingTaskType.WEAVE_INHERITED_MEMBER_ACCESS);
                                subclass.addWeavingTask(newTask, true);
                                affectedClasses.add(subclass);
                            }
                            break;
                        }
                        case WEAVE_METHOD_ACCESS: {
                            this.prepareForFirstMemberAccess();
                            Method method = this.getMethod((WeavingTask)task);
                            this.weaveMethodAccess(method, method.getGlobalId(this));
                            if (method.isStatic()) break;
                            for (AbstractBoundClass subclass : this.getSubclasses()) {
                                WeavingTask newTask3 = new WeavingTask(WeavingTaskType.WEAVE_INHERITED_MEMBER_ACCESS);
                                subclass.addWeavingTask(newTask3, true);
                                affectedClasses.add(subclass);
                            }
                            break;
                        }
                        case WEAVE_INHERITED_MEMBER_ACCESS: {
                            this.prepareForFirstMemberAccess();
                            break;
                        }
                        case WEAVE_BASE_INFRASTRUCTURE: {
                            this.prepareForFirstTransformation();
                        }
                    }
                    this.completedAccessTasks.put(member, (WeavingTask)task);
                }
                for (final AbstractBoundClass abstractBoundClass2 : affectedClasses) {
                    if (!abstractBoundClass2.isLoaded || this.weavingContext.scheduleReweaving(abstractBoundClass2.name, (IReweavingTask)(task = new IReweavingTask(){

                        public void reweave(Class<?> definedClass) throws IllegalClassFormatException {
                            abstractBoundClass2.handleTaskList(definedClass);
                        }
                    }))) continue;
                    abstractBoundClass2.handleTaskList(definedClass);
                }
                if (!processingOpenTasks) continue;
                this.endTransformation(definedClass);
            }
        }
        this.superTransformation(definedClass);
    }

    protected abstract void createSuperCalls();

    protected abstract void propagateCallinInfraToSubclasses();

    private boolean hierarchyIsCallinAffected() {
        if (this.hierarchyIsCallinAffected) {
            return true;
        }
        AbstractBoundClass zuper = this.getSuperclass();
        if (!zuper.isJavaLangObject() && zuper.hierarchyIsCallinAffected()) {
            this.hierarchyIsCallinAffected = true;
            return true;
        }
        return false;
    }

    <K, V> Set<Map.Entry<K, V>> copyEntrySet(Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptySet();
        }
        HashMap<K, V> bindingMap = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            bindingMap.put(entry.getKey(), entry.getValue());
        }
        return bindingMap.entrySet();
    }

    public void handleAddingOfBinding(IBinding binding) {
        WeavingTaskType type = null;
        WeavingTask task = null;
        switch (binding.getType()) {
            case CALLIN_BINDING: {
                type = WeavingTaskType.WEAVE_BINDING;
                break;
            }
            case FIELD_ACCESS: {
                type = WeavingTaskType.WEAVE_FIELD_ACCESS;
                break;
            }
            case METHOD_ACCESS: {
                type = WeavingTaskType.WEAVE_METHOD_ACCESS;
                break;
            }
            case ROLE_BASE_BINDING: {
                task = new WeavingTask(WeavingTaskType.WEAVE_BASE_INFRASTRUCTURE);
                break;
            }
            default: {
                throw new RuntimeException("Unknown binding type: " + binding.getType().name());
            }
        }
        if (task == null) {
            task = new WeavingTask(type, binding.getMemberName(), binding.getMemberSignature(), binding.getBaseFlags(), binding.isHandleCovariantReturn(), binding.requiresBaseSuperCall());
        }
        try {
            this.addWeavingTask(task, false);
        }
        catch (IllegalClassFormatException e) {
            e.printStackTrace();
        }
    }

    public synchronized void startTransaction() {
        ++this.transactionCount;
    }

    public synchronized void commitTransaction(Class<?> definedClass) {
        --this.transactionCount;
        if (this.transactionCount == 0 && this.isLoaded) {
            try {
                this.handleTaskList(definedClass);
            }
            catch (IllegalClassFormatException e) {
                e.printStackTrace();
            }
        }
    }

    private void addWeavingTask(WeavingTask task, boolean standBy) throws IllegalClassFormatException {
        boolean isNewTask = this.addWeavingTaskLazy(task);
        if (this.isLoaded && isNewTask && !standBy && this.transactionCount == 0) {
            this.handleTaskList(null);
        }
    }

    private boolean addWeavingTaskLazy(WeavingTask task) {
        WeavingTaskType type = task.getType();
        boolean isNewTask = false;
        isNewTask = type == WeavingTaskType.WEAVE_BINDING || type == WeavingTaskType.WEAVE_BINDING_OF_SUBCLASS || type == WeavingTaskType.WEAVE_INHERITED_BINDING ? this.addBindingWeavingTask(task) : this.addAccessWeavingTask(task);
        return isNewTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean addAccessWeavingTask(WeavingTask task) {
        WeavingTaskType type = task.getType();
        Member member = null;
        switch (type) {
            case WEAVE_FIELD_ACCESS: {
                member = this.getField(task.getMemberName(), task.getMemberSignature());
                break;
            }
            case WEAVE_METHOD_ACCESS: {
                member = this.getMethod(task);
            }
        }
        Map<Method, WeavingTask> map = this.openBindingTasks;
        synchronized (map) {
            switch (type) {
                case WEAVE_INHERITED_MEMBER_ACCESS: 
                case WEAVE_BASE_INFRASTRUCTURE: {
                    this.openAccessTasks.put(null, task);
                    return true;
                }
            }
            Member member2 = member;
            synchronized (member2) {
                WeavingTask prevTask = this.completedAccessTasks.get(member);
                if (prevTask == null) {
                    prevTask = this.openAccessTasks.get(member);
                }
                if (prevTask == null) {
                    this.openAccessTasks.put(member, task);
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean addBindingWeavingTask(WeavingTask task) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addWeavingOfSubclassTask(String methodName, String signature, boolean isStatic) {
        int flags = isStatic ? 2 : 0;
        this.addBindingWeavingTask(new WeavingTask(WeavingTaskType.WEAVE_BINDING_OF_SUBCLASS, methodName, signature, flags, true, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean mergeTasks(AbstractBoundClass clazz) {
        Set<Map.Entry<Member, WeavingTask>> otherAccessTasks;
        Set<Map.Entry<Method, WeavingTask>> otherBindingTasks;
        boolean isNewTask = false;
        Map<Method, WeavingTask> map = clazz.openBindingTasks;
        synchronized (map) {
            otherBindingTasks = clazz.openBindingTasks.entrySet();
            otherAccessTasks = clazz.openAccessTasks.entrySet();
        }
        for (Map.Entry<Method, WeavingTask> entry : otherBindingTasks) {
            isNewTask |= this.addWeavingTaskLazy(entry.getValue());
        }
        for (Map.Entry<Member, WeavingTask> entry : otherAccessTasks) {
            isNewTask |= this.addWeavingTaskLazy(entry.getValue());
        }
        return isNewTask;
    }

    private void weaveBindingInStaticMethod(WeavingTask task) {
        this.prepareForFirstStaticTransformation();
        Method method = this.getMethod(task);
        int joinpointId = TeamManager.getJoinpointId((String)this.getMethodIdentifier(method));
        int boundMethodId = method.getGlobalId(this);
        this.moveCodeToCallOrig(method, boundMethodId, false);
        this.createDispatchCodeInOrgMethod(method, joinpointId, boundMethodId);
    }

    private void weaveBindingInNotImplementedMethod(WeavingTask task, boolean needToAddMethod) {
        if ((task.getBaseFlags() & 2) == 0) {
            this.prepareForFirstTransformation();
        } else {
            this.prepareForFirstStaticTransformation();
        }
        Method method = this.getMethod(task);
        int joinpointId = TeamManager.getJoinpointId((String)task.getMethodIdentifier(this));
        int boundMethodId = method.getGlobalId(this);
        if (task.doAllTransformations()) {
            this.createDispatchCodeInCallAllBindings(joinpointId, boundMethodId);
            boolean isWeavable = true;
            AbstractBoundClass superClass = this.getSuperclass();
            while (superClass != null) {
                if (superClass.isJavaLangObject()) {
                    isWeavable = false;
                    break;
                }
                Method superMethod = superClass.getMethod(task);
                if (superMethod.isImplemented()) {
                    isWeavable = this.weavingContext.isWeavable(superClass.getName(), false, false);
                    break;
                }
                superClass = superClass.getSuperclass();
            }
            if (isWeavable) {
                this.createSuperCallInCallOrig(boundMethodId);
            } else {
                this.createCallAllBindingsCallInOrgMethod(method, boundMethodId, needToAddMethod);
            }
        } else {
            this.createDispatchCodeInCallAllBindings(joinpointId, boundMethodId);
        }
    }

    private void weaveSuperCallInCallOrig(WeavingTask task) {
        this.prepareForFirstTransformation();
        Method method = this.getMethod(task);
        int boundMethodId = method.getGlobalId(this);
        if (task.doAllTransformations()) {
            this.createSuperCallInCallOrig(boundMethodId);
        }
    }

    private void weaveBindingInImplementedMethod(WeavingTask task) {
        this.prepareForFirstTransformation();
        Method method = this.getMethod(task);
        int joinpointId = TeamManager.getJoinpointId((String)this.getMethodIdentifier(method));
        int boundMethodId = method.getGlobalId(this);
        if (task.doAllTransformations()) {
            this.moveCodeToCallOrig(method, boundMethodId, task.requiresBaseSuperCall());
            this.createDispatchCodeInCallAllBindings(joinpointId, boundMethodId);
            this.createCallAllBindingsCallInOrgMethod(method, boundMethodId, false);
        } else {
            this.createDispatchCodeInCallAllBindings(joinpointId, joinpointId);
        }
    }

    private void weaveBindingOfSubclass(WeavingTask task) {
        this.prepareForFirstTransformation();
        Method method = this.getMethod(task);
        int boundMethodId = method.getGlobalId(this);
        this.moveCodeToCallOrig(method, boundMethodId, false);
        this.createCallAllBindingsCallInOrgMethod(method, boundMethodId, false);
    }

    protected abstract void replaceWickedSuperCalls(AbstractBoundClass var1, Method var2);

    public String toString() {
        return String.valueOf(this.name) + "[" + this.id + "]";
    }

    protected abstract void startTransformation();

    protected abstract void endTransformation(Class<?> var1) throws IllegalClassFormatException;

    protected abstract void superTransformation(Class<?> var1) throws IllegalClassFormatException;

    protected abstract void prepareAsPossibleBaseClass();

    protected abstract void prepareTeamActivation();

    protected abstract void prepareLiftingParticipant();

    protected abstract void createSuperCallInCallOrig(int var1);

    protected abstract void createCallAllBindingsCallInOrgMethod(Method var1, int var2, boolean var3);

    protected abstract void createDispatchCodeInCallAllBindings(int var1, int var2);

    protected abstract void moveCodeToCallOrig(Method var1, int var2, boolean var3);

    protected abstract void prepareForFirstTransformation();

    protected abstract void prepareForFirstStaticTransformation();

    public abstract boolean isFirstTransformation();

    public boolean isLoaded() {
        return this.isLoaded;
    }

    protected abstract void createDispatchCodeInOrgMethod(Method var1, int var2, int var3);

    protected abstract void prepareForFirstMemberAccess();

    protected abstract void weaveFieldAccess(Field var1, int var2);

    protected abstract void weaveMethodAccess(Method var1, int var2);

    public abstract boolean isTransformationActive();

    public abstract byte[] getBytecode();

    public void dump(byte[] classfileBuffer, String postfix) {
    }

    public Collection<String> getBoundBaseClasses() {
        return null;
    }

    public abstract int compare(String var1, String var2);

    public void addWiringTask(ISubclassWiringTask wiringTask) {
        if (this.wiringTasks == null) {
            this.wiringTasks = new ArrayList<ISubclassWiringTask>();
        }
        this.wiringTasks.add(wiringTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performWiringTasks(AbstractBoundClass superclass, AbstractBoundClass subclass) {
        if (this.wiringTasks == null) {
            return;
        }
        List<ISubclassWiringTask> list = this.wiringTasks;
        synchronized (list) {
            for (ISubclassWiringTask task : this.wiringTasks) {
                task.wire((IBoundClass)superclass, (IBoundClass)subclass);
            }
            this.wiringTasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsWeaving() {
        Map<Method, WeavingTask> map = this.openBindingTasks;
        synchronized (map) {
            return !this.openAccessTasks.isEmpty() || !this.openBindingTasks.isEmpty();
        }
    }

    public void markAsUnweavable() {
        this.isUnweavable = true;
    }

    public abstract void toDebugString(StringBuilder var1, String var2);

    private static class WeavingTask {
        private WeavingTaskType weavingTaskType;
        private String memberName;
        private String memberSignature;
        private String memberPrefixId;
        private int baseFlags;
        private boolean doAllTransformations;
        private boolean isHandleCovariantReturn;
        private boolean requireBaseSuperCall;

        public WeavingTask(WeavingTaskType weavingTaskType, String memberName, String memberSignature, int baseFlags, boolean handleCovariantReturn, boolean requireBaseSuperCall) {
            this.weavingTaskType = weavingTaskType;
            this.memberName = memberName;
            this.memberSignature = memberSignature;
            this.isHandleCovariantReturn = handleCovariantReturn;
            this.requireBaseSuperCall = requireBaseSuperCall;
            this.baseFlags = baseFlags;
        }

        public WeavingTask(WeavingTaskType weavingTaskType, Method method, WeavingTask upstream, AbstractBoundClass upstreamClass) {
            this(weavingTaskType, method.getName(), method.getSignature(), upstream.getBaseFlags(), upstream.isHandleCovariantReturn(), false);
            if (weavingTaskType == WeavingTaskType.WEAVE_INHERITED_BINDING && upstream != null && (upstream.getBaseFlags() & 8) != 0 && upstreamClass != null) {
                this.memberPrefixId = upstreamClass.getId();
            }
        }

        public WeavingTask(WeavingTaskType type) {
            this(type, null, null, 0, false, false);
        }

        public WeavingTaskType getType() {
            return this.weavingTaskType;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public String getMemberSignature() {
            return this.memberSignature;
        }

        public String getMethodIdentifier(AbstractBoundClass clazz) {
            String prefix = this.memberPrefixId != null ? this.memberPrefixId : clazz.getId();
            int close = this.memberSignature.lastIndexOf(41);
            return String.valueOf(prefix) + '.' + this.memberName + this.memberSignature.substring(0, close + 1);
        }

        public int getBaseFlags() {
            return this.baseFlags;
        }

        public boolean doAllTransformations() {
            return this.doAllTransformations;
        }

        public void setDoAllTransformations(boolean doAllTransformations) {
            this.doAllTransformations = doAllTransformations;
        }

        public boolean isHandleCovariantReturn() {
            return this.isHandleCovariantReturn;
        }

        public boolean requiresBaseSuperCall() {
            return this.requireBaseSuperCall;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append((Object)this.weavingTaskType).append(": ");
            if (this.memberPrefixId != null) {
                buf.append(this.memberPrefixId).append('-');
            }
            buf.append(this.memberName).append(this.memberSignature);
            return buf.toString();
        }
    }

    private static enum WeavingTaskType {
        WEAVE_BINDING_OF_SUBCLASS,
        WEAVE_BINDING,
        WEAVE_INHERITED_BINDING,
        WEAVE_METHOD_ACCESS,
        WEAVE_FIELD_ACCESS,
        WEAVE_INHERITED_MEMBER_ACCESS,
        WEAVE_BASE_INFRASTRUCTURE;

    }
}

