/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.response;

import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;

public class VMResponse
implements Serializable {
    private static final long serialVersionUID = 8136163293629606805L;
    public static final int STATUS_OK = 0;
    public static final int STATUS_ERROR = 1;
    public final int status;

    public static @NonNull VMResponse createERROR() {
        return new VMResponse(1);
    }

    public static @NonNull VMResponse createOK() {
        return new VMResponse();
    }

    public static @NonNull String toStatusString(int status) {
        switch (status) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "ERROR";
            }
        }
        return "???";
    }

    protected VMResponse() {
        this(0);
    }

    protected VMResponse(int status) {
        this.status = status;
    }

    public boolean isOK() {
        return this.status == 0;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + VMResponse.toStatusString(this.status) + ")";
    }
}

