/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.resource;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.AbstractASResourceFactory;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.Technology;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.uml.internal.resource.UMLASResourceImpl;
import org.eclipse.ocl.pivot.uml.internal.utilities.UMLEcoreTechnology;
import org.eclipse.ocl.pivot.uml.internal.validation.UMLOCLEValidator;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UMLResource;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;

public final class UMLASResourceFactory
extends AbstractASResourceFactory {
    private static @Nullable UMLASResourceFactory INSTANCE;

    public static synchronized @NonNull UMLASResourceFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UMLASResourceFactory();
            assert (INSTANCE != null);
            INSTANCE.install("uml", INSTANCE.getResourceClassName());
        }
        assert (INSTANCE != null);
        return INSTANCE;
    }

    public UMLASResourceFactory() {
        super("org.eclipse.ocl.oclas.uml");
    }

    public void configure(@NonNull ResourceSet resourceSet) {
        super.configure(resourceSet);
        UMLResourcesUtil.init((ResourceSet)resourceSet);
    }

    public @NonNull Resource createResource(URI uri) {
        assert (uri != null);
        UMLASResourceImpl asResource = new UMLASResourceImpl(uri, (ASResourceFactory)this);
        this.configureResource((ASResource)asResource);
        return asResource;
    }

    public <T extends Element> @Nullable T getASElement(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull java.lang.Class<T> pivotClass, @NonNull EObject eObject) throws ParserException {
        Resource metamodel = eObject.eResource();
        if (metamodel == null) {
            return null;
        }
        UML2AS uml2as = UML2AS.getAdapter(metamodel, environmentFactory);
        uml2as.getASModel();
        EClass eClass = eObject.eClass();
        EPackage ePackage = eClass.getEPackage();
        if (ePackage == EcorePackage.eINSTANCE) {
            EClass eStereotype;
            Stereotype umlStereotype;
            if (eObject instanceof EOperation) {
                EOperation eOperation = (EOperation)eObject;
                Constraint umlConstraint = this.getConstraintForEOperation(environmentFactory, eOperation);
                if (umlConstraint != null) {
                    eObject = umlConstraint;
                }
            } else if (eObject instanceof EClass && (umlStereotype = this.getStereotypeForEClass(environmentFactory, eStereotype = (EClass)eObject)) != null) {
                eObject = umlStereotype;
            }
        }
        return (T)uml2as.getCreated(pivotClass, eObject);
    }

    public @NonNull ASResourceFactory getASResourceFactory() {
        return UMLASResourceFactory.getInstance();
    }

    protected Constraint getConstraintForEOperation(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull EOperation eOperation) {
        String operationName;
        Constraint umlConstraint;
        EObject eReference;
        EList eReferences;
        EClass eContainingClass;
        EAnnotation eAnnotation;
        if (EcoreUtil.isInvariant((EOperation)eOperation) && (eAnnotation = (eContainingClass = eOperation.getEContainingClass()).getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML")) != null && (eReferences = eAnnotation.getReferences()) != null && eReferences.size() > 0 && (eReference = (EObject)eReferences.get(0)) instanceof Type && (umlConstraint = ((Classifier)eReference).getOwnedRule(operationName = environmentFactory.getTechnology().getOriginalName((ENamedElement)eOperation))) != null) {
            return umlConstraint;
        }
        return null;
    }

    public @Nullable EOperation getEOperation(@NonNull ASResource asResource, @NonNull EObject eObject) {
        UMLASResourceImpl umlResource = (UMLASResourceImpl)asResource;
        if (!(eObject instanceof Operation)) {
            return null;
        }
        Operation umlOperation = (Operation)eObject;
        Class umlClass = umlOperation.getClass_();
        if (umlClass == null) {
            return null;
        }
        EClassifier eClassifier = umlResource.getEClassifier((Type)umlClass);
        if (eClassifier == null) {
            return null;
        }
        if (!(eClassifier instanceof EClass)) {
            return null;
        }
        String operationName = umlOperation.getName();
        if (operationName == null) {
            return null;
        }
        EList umlParameters = umlOperation.getOwnedParameters();
        int umlParameterCount = umlParameters.size();
        for (EOperation eOperation : ((EClass)eClassifier).getEOperations()) {
            EList eParameters;
            int eParameterCount;
            if (!operationName.equals(eOperation.getName()) || umlParameterCount < (eParameterCount = (eParameters = eOperation.getEParameters()).size())) continue;
            boolean parametersMatch = true;
            int umlIndex = 0;
            int eIndex = 0;
            while (eIndex < eParameterCount && umlIndex < umlParameterCount) {
                EClassifier eParameterType;
                Parameter umlInParameter = null;
                while (umlIndex < umlParameterCount) {
                    Parameter umlParameter;
                    if ((umlParameter = (Parameter)umlParameters.get(umlIndex++)).getDirection() != ParameterDirectionKind.IN_LITERAL) continue;
                    umlInParameter = umlParameter;
                    break;
                }
                if (umlInParameter == null) {
                    parametersMatch = false;
                    break;
                }
                EParameter eParameter = (EParameter)eParameters.get(eIndex++);
                Type umlParameterType = umlInParameter.getType();
                EClassifier umlEParameterType = umlParameterType != null ? umlResource.getEClassifier(umlParameterType) : null;
                if (umlEParameterType == (eParameterType = eParameter.getEType())) continue;
                parametersMatch = false;
                break;
            }
            while (umlIndex < umlParameterCount) {
                Parameter umlParameter;
                if ((umlParameter = (Parameter)umlParameters.get(umlIndex++)).getDirection() != ParameterDirectionKind.IN_LITERAL) continue;
                parametersMatch = false;
                break;
            }
            if (eIndex != eParameterCount || umlIndex != umlParameterCount || !parametersMatch) continue;
            return eOperation;
        }
        return null;
    }

    public @Nullable EReference getEReference(@NonNull ASResource asResource, @NonNull EObject eObject) {
        UMLASResourceImpl umlResource = (UMLASResourceImpl)asResource;
        if (!(eObject instanceof Property)) {
            return null;
        }
        Property umlProperty = (Property)eObject;
        Class umlClass = umlProperty.getClass_();
        if (umlClass == null) {
            return null;
        }
        EClassifier eClassifier = umlResource.getEClassifier((Type)umlClass);
        if (eClassifier == null) {
            return null;
        }
        if (!(eClassifier instanceof EClass)) {
            return null;
        }
        String propertyName = umlProperty.getName();
        if (propertyName == null) {
            return null;
        }
        for (EReference eReference : ((EClass)eClassifier).getEReferences()) {
            if (!propertyName.equals(eReference.getName())) continue;
            return eReference;
        }
        return null;
    }

    public @NonNull Technology getTechnology() {
        UMLStandaloneSetup.assertInitialized();
        return UMLEcoreTechnology.INSTANCE;
    }

    public @Nullable String getMetamodelNsURI(@NonNull EPackage ePackage) {
        if (ePackage instanceof UMLPackage) {
            return "http://www.omg.org/spec/UML/20131001";
        }
        if (ePackage.getClass().getName().startsWith(UMLPackage.class.getPackage().getName())) {
            return "http://www.omg.org/spec/UML/20131001";
        }
        return null;
    }

    public @Nullable URI getPackageURI(@NonNull EObject eObject) {
        String uri;
        if (eObject instanceof Package && (uri = ((Package)eObject).getURI()) != null) {
            return URI.createURI((String)uri);
        }
        return null;
    }

    public @Nullable Integer getPriority() {
        return 200;
    }

    public @Nullable String getResourceClassName() {
        return UMLResource.class.getName();
    }

    protected Stereotype getStereotypeForEClass(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull EClass eClass) {
        EObject eAnnotationParent = null;
        EClass eObject = eClass;
        while (true) {
            if (eObject == null) {
                return null;
            }
            if (eObject instanceof EAnnotation) break;
            eObject = eObject.eContainer();
        }
        eAnnotationParent = eObject.eContainer();
        if (!(eAnnotationParent instanceof Profile)) {
            return null;
        }
        Profile umlProfile = (Profile)eAnnotationParent;
        Stereotype umlStereotype = umlProfile.getOwnedStereotype(NameUtil.getOriginalName((ENamedElement)eClass));
        return umlStereotype;
    }

    public @Nullable Element importFromResource(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Resource umlResource, @Nullable URI uri) throws ParserException {
        String uriFragment;
        UML2AS conversion = UML2AS.getAdapter(umlResource, environmentFactory);
        conversion.setUMLURI(uri != null ? uri.trimFragment() : null);
        Model pivotModel = conversion.getASModel();
        String string = uriFragment = uri != null ? uri.fragment() : null;
        if (uriFragment == null) {
            return pivotModel;
        }
        EObject eObject = umlResource.getEObject(uriFragment);
        if (eObject == null) {
            return null;
        }
        return conversion.getCreated(Element.class, eObject);
    }

    public void initializeEValidatorRegistry(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull EValidator.Registry eValidatorRegistry) {
        eValidatorRegistry.put((Object)UMLPackage.eINSTANCE, (Object)UMLOCLEValidator.NO_NEW_LINES);
    }
}

