/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.DragAndDropFeedback;
import org.eclipse.emf.edit.domain.EditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ResourceCommand
extends AbstractOverrideableCommand
implements AbstractCommand.NonDirtying,
DragAndDropFeedback {
    protected Collection<?> collection;
    protected List<Resource> resources;

    protected ResourceCommand(EditingDomain domain, Collection<?> collection) {
        super(domain);
        this.collection = collection == null ? Collections.emptyList() : collection;
    }

    protected abstract boolean prepare();

    public abstract void doExecute();

    public void doUndo() {
        this.domain.getResourceSet().getResources().removeAll(this.resources);
        this.resources = null;
    }

    public void doRedo() {
        this.doExecute();
    }

    public Collection<?> doGetAffectedObjects() {
        return this.resources == null ? Collections.singleton(this.domain.getResourceSet()) : this.resources;
    }

    public String doGetDescription() {
        return EMFEditPlugin.INSTANCE.getString("_UI_LoadResources_description");
    }

    public String doGetLabel() {
        return EMFEditPlugin.INSTANCE.getString("_UI_LoadResources_label");
    }

    public boolean validate(Object owner, float location, int operations, int operation, Collection<?> collection) {
        return false;
    }

    public int getFeedback() {
        return 0;
    }

    public int getOperation() {
        return 1;
    }
}

