/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.oomph.setup.ui.P2TaskUIServicesPrompter;
import org.eclipse.oomph.setup.ui.Questionnaire;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.EditorSelectionDialog;

public class SetupPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.oomph.setup.SetupPreferencePage";
    private IWorkbench workbench;
    private ComboFieldEditor p2StartupTasks;
    private BooleanFieldEditor skipStartupTasks;
    private Composite parent;

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return SetupUIPlugin.INSTANCE.getPreferenceStore();
    }

    protected void createFieldEditors() {
        this.parent = this.getFieldEditorParent();
        this.skipStartupTasks = this.addBooleanField(this.parent, "skip.startup.tasks", "Skip automatic task execution at startup time", "Don't automatically perform setup tasks when a new workspace is opened");
        this.p2StartupTasks = new ComboFieldEditor("p2.startup.tasks", "Install requirements on startup", (String[][])new String[][]{{"Prompt", P2TaskUIServicesPrompter.Action.PROMPT.name()}, {"Always", P2TaskUIServicesPrompter.Action.ALWAYS.name()}, {"Never", P2TaskUIServicesPrompter.Action.NEVER.name()}}, this.parent);
        this.addField((FieldEditor)this.p2StartupTasks);
        this.p2StartupTasks.fillIntoGrid(this.parent, 3);
        Label p2StartupTasksLabel = this.p2StartupTasks.getLabelControl(this.parent);
        GridData gridData = (GridData)p2StartupTasksLabel.getLayoutData();
        gridData.horizontalIndent = 20;
        p2StartupTasksLabel.setToolTipText("What to do when the installation doesn't satisfy the requirements of what should be installed");
        this.p2StartupTasks.setEnabled(!this.skipStartupTasks.getBooleanValue(), this.parent);
        this.addBooleanField(this.parent, "showToolBarContributions", "Show tool bar contributions", "Show the 'Perform Setup Tasks' and 'Open Setups' tool bar contributions on the main tool bar");
        this.addBooleanField(this.parent, "showProgressInWizard", "Show progress in setup wizard", "Don't automatically minimize the setup wizard when it starts performing.\nIf this setting is enabled the wizard can be manually minimized.\nA minimized wizard can be restored by clicking the animated perform\nbutton in the status bar in front of the progress indicator.");
        StringButtonFieldEditor preferredTextEditor = new StringButtonFieldEditor("preferred.text.editor", "Preferred text editor for models", this.parent){

            protected String changePressed() {
                IEditorDescriptor descriptor;
                EditorSelectionDialog dialog = new EditorSelectionDialog(SetupPreferencePage.this.getControl().getShell());
                dialog.setMessage("Choose the editor to open when 'Open in text editor' is selected in a model editor:");
                if (dialog.open() == 0 && (descriptor = dialog.getSelectedEditor()) != null) {
                    return descriptor.getId();
                }
                return null;
            }
        };
        this.addField((FieldEditor)preferredTextEditor);
        preferredTextEditor.fillIntoGrid(this.parent, 3);
        preferredTextEditor.getLabelControl(this.parent).setToolTipText("The editor to open when 'Open in text editor' is selected in a model editor");
        if (Questionnaire.exists()) {
            Button questionnaireButton = new Button(this.parent, 8);
            questionnaireButton.setText("Start Welcome Questionnaire...");
            questionnaireButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Shell shell = SetupPreferencePage.this.workbench.getActiveWorkbenchWindow().getShell();
                    IPreferencePageContainer container = SetupPreferencePage.this.getContainer();
                    if (container instanceof IShellProvider) {
                        shell = ((IShellProvider)container).getShell();
                    }
                    Shell parentShell = shell;
                    Questionnaire.perform(parentShell, true);
                }
            });
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.skipStartupTasks) {
            this.p2StartupTasks.setEnabled(!Boolean.TRUE.equals(event.getNewValue()), this.parent);
        }
    }

    private BooleanFieldEditor addBooleanField(Composite parent, String preferenceName, String label, String toolTip) {
        BooleanFieldEditor fieldEditor = new BooleanFieldEditor(preferenceName, label, parent);
        fieldEditor.fillIntoGrid(parent, 3);
        this.addField((FieldEditor)fieldEditor);
        fieldEditor.getDescriptionControl(parent).setToolTipText(toolTip);
        return fieldEditor;
    }
}

