/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.expressions.catalog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.infra.emf.expressions.ExpressionCatalog;

public class ExpressionCatalogRegistry {
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.emf.expressions.expressionCatalog";
    public static final String FILE_ATTRIBUTE = "file";
    private List<ExpressionCatalog> catalogs = new ArrayList<ExpressionCatalog>();
    public static final ExpressionCatalogRegistry INSTANCE = new ExpressionCatalogRegistry();
    private ResourceSet resourceSet;

    private ExpressionCatalogRegistry() {
        this.initFields();
    }

    private void initFields() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        this.resourceSet = new ResourceSetImpl();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            EObject first;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String file = iConfigurationElement.getAttribute(FILE_ATTRIBUTE);
            IContributor contributor = iConfigurationElement.getContributor();
            URI uri = URI.createPlatformPluginURI((String)(String.valueOf(contributor.getName()) + "/" + file.toString()), (boolean)true);
            Resource res = this.resourceSet.getResource(uri, true);
            if (res.getContents().size() > 0 && (first = (EObject)res.getContents().get(0)) instanceof ExpressionCatalog) {
                this.catalogs.add((ExpressionCatalog)first);
            }
            ++n2;
        }
    }

    public List<ExpressionCatalog> getAllRegisteredCatalog() {
        return this.catalogs;
    }
}

