/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.osgi.framework.Bundle;

class MultiBundleClassLoader2
extends ClassLoader {
    private List<Bundle> bundleList;

    public MultiBundleClassLoader2(List<Bundle> platformEngineBundles) {
        this.bundleList = platformEngineBundles;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class c = null;
        for (Bundle temp : this.bundleList) {
            try {
                c = temp.loadClass(name);
                if (c == null) continue;
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return c;
    }

    @Override
    protected URL findResource(String name) {
        URL url = null;
        for (Bundle temp : this.bundleList) {
            url = temp.getResource(name);
            if (url == null) continue;
            return url;
        }
        return url;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Enumeration enumFinal = null;
        int i = 0;
        while (i < this.bundleList.size()) {
            if (i == 0) {
                enumFinal = this.bundleList.get(i).getResources(name);
            } else {
                Enumeration e2 = this.bundleList.get(i).getResources(name);
                Vector<URL> temp = new Vector<URL>();
                while (enumFinal != null && enumFinal.hasMoreElements()) {
                    temp.add((URL)enumFinal.nextElement());
                }
                while (e2 != null && e2.hasMoreElements()) {
                    temp.add((URL)e2.nextElement());
                }
                enumFinal = temp.elements();
            }
            ++i;
        }
        return enumFinal;
    }
}

