/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.pde.internal.junit.runtime.PDEJUnitRuntimePlugin;
import org.eclipse.pde.internal.junit.runtime.PlatformUITestHarness;
import org.junit.Assert;

public class NonUIThreadTestApplication
implements IApplication {
    private static final String DEFAULT_HEADLESSAPP = "org.eclipse.pde.junit.runtime.coretestapplication";
    protected IApplication fApplication;
    protected Object fTestHarness;

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        String appId = this.getApplicationToRun(args);
        Object app = this.getApplication(appId);
        Assert.assertNotNull((Object)app);
        if (!DEFAULT_HEADLESSAPP.equals(appId)) {
            this.installPlatformUITestHarness();
        }
        return this.runApp(app, context, args);
    }

    protected Object runApp(Object app, IApplicationContext context, String[] args) throws Exception {
        if (app instanceof IApplication) {
            this.fApplication = (IApplication)app;
            return this.fApplication.start(context);
        }
        return ((IPlatformRunnable)app).run((Object)args);
    }

    private void installPlatformUITestHarness() throws Exception {
        Object testableObject = PDEJUnitRuntimePlugin.getDefault().getTestableObject();
        if (testableObject == null) {
            try {
                Class<?> platformUIClass = Class.forName("org.eclipse.ui.PlatformUI", true, this.getClass().getClassLoader());
                testableObject = platformUIClass.getMethod("getTestableObject", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (testableObject != null) {
            this.fTestHarness = new PlatformUITestHarness(testableObject, true);
        }
    }

    public void stop() {
        if (this.fApplication != null) {
            this.fApplication.stop();
        }
        if (this.fTestHarness != null) {
            this.fTestHarness = null;
        }
    }

    private Object getApplication(String appId) throws CoreException {
        Object runnable;
        IConfigurationElement[] runs;
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.runtime", "applications", appId);
        Assert.assertNotNull((Object)extension);
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements.length > 0 && (runs = elements[0].getChildren("run")).length > 0 && ((runnable = runs[0].createExecutableExtension("class")) instanceof IPlatformRunnable || runnable instanceof IApplication)) {
            return runnable;
        }
        return null;
    }

    private String getApplicationToRun(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-testApplication") && i < args.length - 1) {
                return args[i + 1];
            }
            ++i;
        }
        IProduct product = Platform.getProduct();
        if (product != null) {
            return product.getApplication();
        }
        return this.getDefaultApplicationId();
    }

    protected String getDefaultApplicationId() {
        return DEFAULT_HEADLESSAPP;
    }
}

