/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.php.composer.api.DistributedPackage;
import org.eclipse.php.composer.api.collection.Persons;
import org.eclipse.php.composer.api.collection.Versions;
import org.eclipse.php.composer.api.json.ParseException;
import org.eclipse.php.composer.api.packages.PackagistDownloader;
import org.eclipse.php.composer.api.repositories.PackageRepository;

public class RepositoryPackage
extends DistributedPackage {
    private Versions versions = new Versions();
    private Persons maintainers = new Persons();

    public RepositoryPackage() {
        this.listen();
    }

    public RepositoryPackage(Object json) {
        this();
        this.fromJson(json);
    }

    public RepositoryPackage(String json) throws ParseException {
        this();
        this.fromJson(json);
    }

    public RepositoryPackage(File file) throws IOException, ParseException {
        this();
        this.fromJson(file);
    }

    public RepositoryPackage(Reader reader) throws IOException, ParseException {
        this();
        this.fromJson(reader);
    }

    public static RepositoryPackage fromPackageRepository(File input) throws IOException, ParseException {
        PackageRepository repo = new PackageRepository(input);
        return repo.getPackage();
    }

    public static RepositoryPackage fromPackageRepository(Reader input) throws IOException, ParseException {
        PackageRepository repo = new PackageRepository(input);
        return repo.getPackage();
    }

    public static RepositoryPackage fromPackagist(String name) throws Exception {
        PackagistDownloader downloader = new PackagistDownloader();
        return downloader.loadPackage(name);
    }

    public Versions getVersions() {
        return this.versions;
    }

    public String getPackageName(String version) throws Exception {
        if (!this.versions.has(version)) {
            throw new Exception("Invalid version " + version + " for package " + this.getName());
        }
        return String.format("%s:%s", this.getName(), version);
    }

    public Persons getMaintainers() {
        return this.maintainers;
    }

    public String getRepository() {
        return this.getAsString("repository");
    }

    public void setRepository(String repository) {
        this.set("repository", repository);
    }
}

