/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.wizard.project.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.equinox.internal.p2.ui.discovery.util.ControlListItem;
import org.eclipse.equinox.internal.p2.ui.discovery.util.ControlListViewer;
import org.eclipse.equinox.internal.p2.ui.discovery.util.FilteredViewer;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.composer.api.MinimalPackage;
import org.eclipse.php.composer.api.packages.AsyncPackagistSearch;
import org.eclipse.php.composer.api.packages.PackageSearchListenerInterface;
import org.eclipse.php.composer.api.packages.SearchResult;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.ui.wizard.project.template.Messages;
import org.eclipse.php.composer.ui.wizard.project.template.PackageFilterChangedListener;
import org.eclipse.php.composer.ui.wizard.project.template.PackageFilterItem;
import org.eclipse.php.composer.ui.wizard.project.template.PackagistItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class PackageFilterViewer
extends FilteredViewer
implements PackageFilterChangedListener {
    protected static final Object[] EMTPY = new Object[0];
    private DiscoveryResources resources;
    private Button showProjectsCheckbox;
    private PackagistContentProvider contentProvider;
    private PackageFilterItem currentSelection = null;
    private List<PackageFilterChangedListener> listeners = new ArrayList<PackageFilterChangedListener>();
    private Label searchResultCount;
    private String lastQuery;

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.doFind("");
    }

    public void addChangeListener(PackageFilterChangedListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    protected StructuredViewer doCreateViewer(Composite container) {
        this.resources = new DiscoveryResources(this.getControl().getDisplay());
        ControlListViewer viewer = new ControlListViewer(container, 2048){

            protected ControlListItem<?> doCreateItem(Composite parent, Object element) {
                return PackageFilterViewer.this.doCreateViewerItem(parent, element);
            }
        };
        this.contentProvider = new PackagistContentProvider();
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.searchResultCount = new Label(container, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).align(1, 0x1000000).hint(400, -1).applyTo((Control)this.searchResultCount);
        return viewer;
    }

    protected void doCreateHeaderControls(Composite parent) {
        this.showProjectsCheckbox = new Button(parent, 32);
        this.showProjectsCheckbox.setSelection(true);
        this.showProjectsCheckbox.setText(Messages.PackageFilterViewer_ProjectsOnlyLabel);
        this.showProjectsCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                PackageFilterViewer.this.doFind(PackageFilterViewer.this.getFilterText());
            }
        });
    }

    protected ControlListItem<?> doCreateViewerItem(Composite parent, Object element) {
        if (element instanceof PackageFilterItem) {
            PackagistItem packagistItem = new PackagistItem(parent, 0, this.resources, (PackageFilterItem)element);
            packagistItem.addFilterChangedListener(this);
            return packagistItem;
        }
        return null;
    }

    protected void doFind(String text) {
        try {
            this.lastQuery = text;
            this.contentProvider.clear();
            this.viewer.setInput((Object)this.contentProvider.packages);
            this.viewer.refresh();
            AsyncPackagistSearch search = new AsyncPackagistSearch();
            search.addPackageSearchListener(new PackageSearchListenerInterface(){

                public void errorOccured(Exception e) {
                }

                public void aborted(String url) {
                }

                public void packagesFound(List<MinimalPackage> packages, final String query, final SearchResult result) {
                    if (packages != null) {
                        final ArrayList<PackageFilterItem> items = new ArrayList<PackageFilterItem>();
                        for (MinimalPackage pkg : packages) {
                            items.add(new PackageFilterItem(pkg));
                        }
                        PackageFilterViewer.this.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (PackageFilterViewer.this.viewer.getControl().isDisposed()) {
                                    return;
                                }
                                if (!Objects.equals(query, PackageFilterViewer.this.lastQuery)) {
                                    return;
                                }
                                PackageFilterViewer.this.contentProvider.add(items);
                                PackageFilterViewer.this.viewer.refresh();
                                PackageFilterViewer.this.viewer.getControl().requestLayout();
                                PackageFilterViewer.this.searchResultCount.setText(NLS.bind((String)Messages.PackageFilterViewer_PackagesFound, (Object)result.total));
                            }
                        });
                    }
                }
            });
            if (this.showProjectsCheckbox.getSelection()) {
                search.setFilter("project");
            }
            if (!text.trim().isEmpty()) {
                search.search(text);
            }
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
    }

    public PackageFilterItem getSelectedPackage() {
        for (PackageFilterItem item : this.contentProvider.packages) {
            if (!item.isChecked()) continue;
            return item;
        }
        return null;
    }

    @Override
    public void filterChanged(PackageFilterItem item) {
        if (this.currentSelection != null && item == this.currentSelection) {
            this.fireEvent(item);
            return;
        }
        List input = (List)this.viewer.getInput();
        if (!item.isChecked()) {
            return;
        }
        for (PackageFilterItem filterItem : input) {
            if (filterItem == item) continue;
            filterItem.setChecked(false);
        }
        ScrolledComposite control = (ScrolledComposite)this.viewer.getControl();
        Point origin = control.getOrigin();
        this.viewer.refresh();
        control.setOrigin(origin);
        this.fireEvent(item);
    }

    protected void fireEvent(PackageFilterItem item) {
        for (PackageFilterChangedListener listener : this.listeners) {
            listener.filterChanged(item);
        }
        this.currentSelection = item;
    }

    protected static class PackagistContentProvider
    implements ITreeContentProvider {
        private List<PackageFilterItem> packages;

        protected PackagistContentProvider() {
        }

        public void dispose() {
            this.packages = null;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (this.packages != null) {
                ArrayList<PackageFilterItem> elements = new ArrayList<PackageFilterItem>();
                elements.addAll(this.packages);
                return elements.toArray(new Object[elements.size()]);
            }
            return EMTPY;
        }

        public Object getParent(Object element) {
            if (element instanceof PackageFilterItem) {
                return this.packages;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof PackageFilterItem) {
                return false;
            }
            if (this.packages != null) {
                return this.packages.size() > 0;
            }
            return false;
        }

        public void add(List<PackageFilterItem> items) {
            if (this.packages != null && items != null) {
                this.packages.addAll(items);
            }
        }

        public void clear() {
            this.packages = new ArrayList<PackageFilterItem>();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.packages = (List)newInput;
        }
    }
}

