/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.mylyn.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.monitor.ui.AbstractEditorTracker;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.mylyn.internal.ui.editor.ActiveFoldingListener;
import org.eclipse.ui.IEditorPart;

public class ActiveFoldingEditorTracker
extends AbstractEditorTracker {
    protected Map<PHPStructuredEditor, ActiveFoldingListener> editorListenerMap = new HashMap<PHPStructuredEditor, ActiveFoldingListener>();

    public void editorOpened(IEditorPart part) {
        if (part instanceof PHPStructuredEditor) {
            this.registerEditor((PHPStructuredEditor)part);
        }
    }

    public void editorClosed(IEditorPart part) {
        if (part instanceof PHPStructuredEditor) {
            this.unregisterEditor((PHPStructuredEditor)part);
        }
    }

    public void registerEditor(PHPStructuredEditor editor) {
        if (this.editorListenerMap.containsKey(editor)) {
            return;
        }
        ActiveFoldingListener listener = new ActiveFoldingListener(editor);
        this.editorListenerMap.put(editor, listener);
    }

    public void unregisterEditor(PHPStructuredEditor editor) {
        ActiveFoldingListener listener = this.editorListenerMap.get(editor);
        if (listener != null) {
            listener.dispose();
        }
        this.editorListenerMap.remove(editor);
    }

    public Map<PHPStructuredEditor, ActiveFoldingListener> getEditorListenerMap() {
        return this.editorListenerMap;
    }

    protected void editorBroughtToTop(IEditorPart part) {
    }
}

