/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.context.ContextViewer;

public class ContextUIManager {
    private static ContextUIManager instance;
    private static final String EXPT_ID = "org.eclipse.rcptt.ui.viewers";
    private ContextViewer[] viewers = null;
    private Map<ContextType, ContextViewer> typeToViewer;

    public static synchronized ContextUIManager getInstance() {
        if (instance == null) {
            instance = new ContextUIManager();
        }
        return instance;
    }

    public ImageDescriptor getIcon(ContextType type) {
        ContextViewer viewer = this.getViewer(type);
        if (viewer != null) {
            return viewer.getIcon();
        }
        return null;
    }

    public ContextViewer getViewer(ContextType type) {
        this.init();
        return this.typeToViewer.get(type);
    }

    public ContextViewer[] getViewers() {
        this.init();
        return this.viewers;
    }

    private synchronized void init() {
        IConfigurationElement[] elements;
        if (this.typeToViewer != null) {
            return;
        }
        this.typeToViewer = new HashMap<ContextType, ContextViewer>();
        ArrayList<ContextViewer> list = new ArrayList<ContextViewer>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXPT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                ContextViewer viewer = new ContextViewer(element);
                list.add(viewer);
                this.typeToViewer.put(viewer.getType(), viewer);
            }
            catch (CoreException e) {
                Q7UIPlugin.log(e);
            }
            ++n2;
        }
        this.viewers = list.toArray(new ContextViewer[list.size()]);
    }
}

