/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.rcptt.core.ecl.model.IDeclContainer;
import org.eclipse.rcptt.core.ecl.model.Q7ElementContainer;
import org.eclipse.rcptt.core.ecl.parser.ast.Node;
import org.eclipse.rcptt.core.ecl.parser.ast.Reference;
import org.eclipse.rcptt.core.ecl.parser.ast.Script;
import org.eclipse.rcptt.core.ecl.parser.model.Resolver;
import org.eclipse.rcptt.ui.editors.ecl.EclSourceViewer;
import org.eclipse.rcptt.ui.editors.ecl.EclTextHyperLink;

public class EclTextHyperLinkDetector
extends AbstractHyperlinkDetector {
    public static IRegion toRegion(Node node) {
        return new Region(node.begin, node.length());
    }

    public static Reference getReferenceAtPoint(ITextViewer viewer, int offset) {
        Q7ElementContainer container = ((EclSourceViewer)viewer).getElementContainer();
        container.includeBuildins(false);
        container.setOffset(offset);
        return Resolver.resolve((Script)container.script, (int)offset, (IDeclContainer)container);
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null) {
            return null;
        }
        int offset = region.getOffset();
        Reference reference = EclTextHyperLinkDetector.getReferenceAtPoint(textViewer, offset);
        if (reference == null) {
            return null;
        }
        return new IHyperlink[]{new EclTextHyperLink(EclTextHyperLinkDetector.toRegion(reference.src), reference.dest)};
    }
}

