/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.views.markers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.ui.markers.AbstractMarker;
import org.eclipse.reddeer.eclipse.ui.markers.matcher.AbstractMarkerMatcher;
import org.eclipse.reddeer.jface.handler.TreeViewerHandler;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.workbench.impl.menu.WorkbenchPartMenuItem;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;
import org.hamcrest.Matcher;

public class AbstractMarkersSupportView
extends WorkbenchView {
    protected TreeViewerHandler treeViewerHandler = TreeViewerHandler.getInstance();

    public AbstractMarkersSupportView(String title) {
        super(title);
    }

    public List<String> getProblemColumns() {
        this.activate();
        return this.getViewTree().getHeaderColumns();
    }

    public void showProblemColumns(Column ... columns) {
        String[] columnsToShow = this.getColumnsToShow(columns);
        if (columnsToShow.length > 0) {
            this.openConfigureColumnsShell();
            new DefaultTable(0, new Matcher[0]).select(columnsToShow);
            new PushButton("Show ->").click();
            this.confirmChangesAndCloseConfigureColumnsShell();
        }
    }

    public void hideProblemColumn(Column ... columns) {
        String[] columnsToHide = this.getColumnsToHide(columns);
        if (columnsToHide.length > 0) {
            this.openConfigureColumnsShell();
            new DefaultTable(1, new Matcher[0]).select(columnsToHide);
            new PushButton("<- Hide ").click();
            this.confirmChangesAndCloseConfigureColumnsShell();
        }
    }

    public void showDefaultProblemColumns() {
        this.openConfigureColumnsShell();
        new PushButton("Restore Defaults").click();
        this.confirmChangesAndCloseConfigureColumnsShell();
    }

    private void openConfigureColumnsShell() {
        this.activate();
        new WorkbenchPartMenuItem(new String[]{"Configure Columns..."}).select();
        new DefaultShell("Configure Columns");
    }

    private void confirmChangesAndCloseConfigureColumnsShell() {
        new OkButton().click();
        new WaitWhile((WaitCondition)new ShellIsAvailable("Configure Columns"));
    }

    public int getIndexOfColumn(String column) {
        return this.getColumnIndex(this.getViewTree().getHeaderColumns(), column);
    }

    public int getIndexOfColumn(Column column) {
        return this.getColumnIndex(this.getViewTree().getHeaderColumns(), column.toString());
    }

    private String[] getColumnsToHide(Column[] columns) {
        List<String> visibleColumns = this.getProblemColumns();
        ArrayList<String> columnsToHide = new ArrayList<String>();
        if (columns != null && columns.length > 0) {
            Column[] columnArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                if (visibleColumns.contains(column.toString())) {
                    columnsToHide.add(column.toString());
                }
                ++n2;
            }
        }
        return columnsToHide.toArray(new String[columnsToHide.size()]);
    }

    private String[] getColumnsToShow(Column[] columns) {
        List<String> visibleColumns = this.getProblemColumns();
        ArrayList<String> columnsToShow = new ArrayList<String>();
        if (columns != null && columns.length > 0) {
            Column[] columnArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                if (!visibleColumns.contains(column.toString())) {
                    columnsToShow.add(column.toString());
                }
                ++n2;
            }
        }
        return columnsToShow.toArray(new String[columnsToShow.size()]);
    }

    private int getColumnIndex(List<String> columns, String column) {
        int index = 0;
        while (index < columns.size()) {
            if (columns.get(index).equals(column)) {
                return index;
            }
            ++index;
        }
        throw new EclipseLayerException("Specified column " + column + " is not presented in a tree of markers.");
    }

    protected <T extends AbstractMarker> List<T> getMarkers(Class<T> clazz, String markerType, AbstractMarkerMatcher ... matchers) {
        ArrayList<AbstractMarker> filteredResult = new ArrayList<AbstractMarker>();
        List<TreeItem> markerItems = this.getAllSpecificMarkerItems(markerType);
        if (markerItems != null) {
            for (TreeItem markerItem : markerItems) {
                if (!this.matchMarkerTreeItem(markerItem, matchers)) continue;
                try {
                    filteredResult.add((AbstractMarker)clazz.getConstructor(String.class, TreeItem.class).newInstance(markerType, markerItem));
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                    throw new EclipseLayerException("Cannot create a new marker.");
                }
            }
        }
        return filteredResult;
    }

    private boolean matchMarkerTreeItem(TreeItem item, AbstractMarkerMatcher ... matchers) {
        boolean itemFitsMatchers = true;
        if (matchers != null) {
            AbstractMarkerMatcher[] abstractMarkerMatcherArray = matchers;
            int n = matchers.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractMarkerMatcher matcher = abstractMarkerMatcherArray[n2];
                try {
                    if (!matcher.matches(item.getCell(this.getIndexOfColumn(matcher.getColumn())))) {
                        itemFitsMatchers = false;
                        break;
                    }
                }
                catch (RedDeerException ex) {
                    if (!item.isDisposed()) {
                        throw ex;
                    }
                    itemFitsMatchers = false;
                }
                ++n2;
            }
        }
        return itemFitsMatchers;
    }

    private List<TreeItem> getAllSpecificMarkerItems(String markerType) {
        String markerTypeSuffix = " \\(\\d+ .*\\)";
        this.activate();
        List markerTypeItems = this.getViewTree().getItems();
        for (TreeItem item : markerTypeItems) {
            try {
                if (!item.getText().matches(String.valueOf(markerType) + markerTypeSuffix)) continue;
                return item.getItems();
            }
            catch (RedDeerException ex) {
                if (item.isDisposed()) continue;
                throw ex;
            }
        }
        return null;
    }

    private Tree getViewTree() {
        return new DefaultTree((ReferencedComposite)this.cTabItem);
    }

    public static enum Column {
        DESCRIPTION("Description"),
        RESOURCE("Resource"),
        PATH("Path"),
        ID("ID"),
        LOCATION("Location"),
        TYPE("Type"),
        CREATION_TIME("Creation Time");

        private final String text;

        private Column(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

