/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.styledtext;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.handler.StyledTextHandler;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.widgets.AbstractControl;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.hamcrest.Matcher;

public abstract class AbstractStyledText
extends AbstractControl<StyledText>
implements org.eclipse.reddeer.swt.api.StyledText {
    private static final Logger log = Logger.getLogger(AbstractStyledText.class);

    protected AbstractStyledText(ReferencedComposite refComposite, int index, Matcher<?> ... matchers) {
        super(StyledText.class, refComposite, index, matchers);
    }

    protected AbstractStyledText(StyledText widget) {
        super(widget);
    }

    @Override
    public String getText() {
        String text = StyledTextHandler.getInstance().getText((StyledText)this.swtWidget);
        return text;
    }

    @Override
    public void setText(String text) {
        log.info("Styled Text set to: " + text);
        StyledTextHandler.getInstance().setText((StyledText)this.swtWidget, text);
    }

    @Override
    public void insertText(int line, int column, String text) {
        log.info("Insert text into styled text on line " + line + ", column " + column + ": " + text);
        StyledTextHandler.getInstance().insertText((StyledText)this.swtWidget, line, column, text);
    }

    @Override
    public void insertText(String text) {
        log.info("Insert text into styled text: " + text);
        StyledTextHandler.getInstance().insertText((StyledText)this.swtWidget, text);
    }

    @Override
    public int getPositionOfText(String text) {
        return StyledTextHandler.getInstance().getPositionOfText((StyledText)this.swtWidget, text);
    }

    @Override
    public void selectText(String text) {
        log.info("Select text " + text + " in styled text");
        StyledTextHandler.getInstance().selectText((StyledText)this.swtWidget, text);
    }

    @Override
    public void setSelection(int start, int end) {
        log.info("Select position start: " + start + " end: " + end + " in styled text");
        StyledTextHandler.getInstance().setSelection((StyledText)this.swtWidget, start, end);
    }

    @Override
    public void selectPosition(int position) {
        log.info("Select position " + position + " in styled text");
        StyledTextHandler.getInstance().selectPosition((StyledText)this.swtWidget, position);
    }

    @Override
    public String getSelectionText() {
        return StyledTextHandler.getInstance().getSelectionText((StyledText)this.swtWidget);
    }

    @Override
    public Point getCursorPosition() {
        return StyledTextHandler.getInstance().getCursorPosition((StyledText)this.swtWidget);
    }
}

