/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.fields.proposal.content;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.AbstractContentProviderAdapter;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class PackageContentProvider
extends AbstractContentProviderAdapter {
    private IJavaProject m_javaProject;

    public PackageContentProvider(IJavaProject jp) {
        this.setJavaProject(jp);
    }

    public String getText(Object element) {
        return ((IPackageFragment)element).getElementName();
    }

    protected Collection<Object> loadProposals(IProgressMonitor monitor) {
        IJavaProject javaProject = this.getJavaProject();
        if (!S2eUtils.exists((IJavaElement)javaProject)) {
            return Collections.emptyList();
        }
        TreeSet<Object> ret = new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return PackageContentProvider.this.getText(o1).compareTo(PackageContentProvider.this.getText(o2));
            }
        });
        try {
            IPackageFragment[] packageFragments;
            IPackageFragment[] iPackageFragmentArray = packageFragments = javaProject.getPackageFragments();
            int n = packageFragments.length;
            int n2 = 0;
            while (n2 < n) {
                String packageName;
                IPackageFragment pck = iPackageFragmentArray[n2];
                if (monitor.isCanceled()) {
                    return ret;
                }
                if (pck.getKind() == 1 && StringUtils.isNotBlank((CharSequence)(packageName = pck.getElementName()))) {
                    ret.add(pck);
                }
                ++n2;
            }
        }
        catch (JavaModelException e1) {
            SdkLog.error((String)"Error while calculating the package proposals for project {}", (Object[])new Object[]{javaProject, e1});
        }
        return ret;
    }

    public IJavaProject getJavaProject() {
        return this.m_javaProject;
    }

    public void setJavaProject(IJavaProject javaProject) {
        if (Objects.equals(javaProject, this.getJavaProject())) {
            return;
        }
        this.m_javaProject = javaProject;
        this.clearCache();
    }
}

