/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.util.ast;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.AbstractAstBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.AstMethodBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.AstNodeFactory;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.AstTypeBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.ILinkedPositionHolder;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ast.AstUtils;

public class AstRadioButtonBuilder
extends AstTypeBuilder<AstRadioButtonBuilder> {
    public static final Set<String> PROPOSAL_RADIO_DATA_TYPES = Collections.synchronizedSortedSet(new TreeSet());

    static {
        PROPOSAL_RADIO_DATA_TYPES.add("java.lang.Long");
        PROPOSAL_RADIO_DATA_TYPES.add("java.lang.Boolean");
        PROPOSAL_RADIO_DATA_TYPES.add("java.math.BigDecimal");
    }

    protected AstRadioButtonBuilder(AstNodeFactory owner) {
        super(owner);
    }

    @Override
    public AstRadioButtonBuilder insert() {
        String genericFromRadioButtonGroupFqn = this.parseValueTypeTypeFromGroup();
        Type genericFromRadioButtonGroupType = this.getFactory().newTypeReference(genericFromRadioButtonGroupFqn);
        ParameterizedType parameterizedType = this.getFactory().getAst().newParameterizedType(this.getSuperType());
        parameterizedType.typeArguments().add(genericFromRadioButtonGroupType);
        this.withSuperType((Type)parameterizedType);
        super.insert();
        this.addGetConfiguredRadioValue(genericFromRadioButtonGroupFqn);
        ILinkedPositionHolder links = this.getFactory().getLinkedPositionHolder();
        if (links != null && this.isCreateLinks()) {
            String[] proposalTypes;
            ITrackedNodePosition dataTypeTracker = this.getFactory().getRewrite().track((ASTNode)genericFromRadioButtonGroupType);
            links.addLinkedPosition(dataTypeTracker, true, "RADIO_VALUE_TYPE");
            links.addLinkedPositionProposalsHierarchy("SUPER_TYPE", "org.eclipse.scout.rt.client.ui.form.fields.button.IRadioButton");
            String[] stringArray = proposalTypes = PROPOSAL_RADIO_DATA_TYPES.toArray(new String[PROPOSAL_RADIO_DATA_TYPES.size()]);
            int n = proposalTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String fqn = stringArray[n2];
                ITypeBinding typeBinding = this.getFactory().resolveTypeBinding(fqn);
                if (typeBinding != null) {
                    links.addLinkedPositionProposal("RADIO_VALUE_TYPE", typeBinding);
                }
                ++n2;
            }
        }
        return this;
    }

    protected String parseValueTypeTypeFromGroup() {
        IType typeBinding = (IType)Validate.notNull((Object)AstUtils.getTypeBinding((AbstractTypeDeclaration)this.getDeclaringType()));
        org.eclipse.scout.sdk.core.model.api.IType scoutType = S2eUtils.jdtTypeToScoutType((IType)typeBinding, (IJavaEnvironment)this.getFactory().getJavaEnvironment());
        List valueSignatures = CoreUtils.getResolvedTypeParamValue((org.eclipse.scout.sdk.core.model.api.IType)scoutType, (String)"org.eclipse.scout.rt.client.ui.form.fields.IValueField", (int)0);
        if (valueSignatures.isEmpty()) {
            return "java.lang.Object";
        }
        return ((org.eclipse.scout.sdk.core.model.api.IType)valueSignatures.get(0)).name();
    }

    protected void addGetConfiguredRadioValue(String valueTypeFqn) {
        AST ast = this.getFactory().getAst();
        Expression initValue = this.getFactory().newDefaultValueExpression(valueTypeFqn, false);
        ReturnStatement returnStatement = ast.newReturnStatement();
        returnStatement.setExpression(initValue);
        Block body = ast.newBlock();
        body.statements().add(returnStatement);
        Type simpleDataType = this.getFactory().newTypeReference(valueTypeFqn);
        ((AstMethodBuilder)((AbstractAstBuilder)((AstMethodBuilder)((AstMethodBuilder)((AstMethodBuilder)this.getFactory().newMethod("getConfiguredRadioValue").withModifiers(Modifier.ModifierKeyword.PROTECTED_KEYWORD)).withOverride(true)).withReturnType(simpleDataType)).withBody(body)).in(this.get())).insert();
        ILinkedPositionHolder links = this.getFactory().getLinkedPositionHolder();
        if (links != null && this.isCreateLinks()) {
            links.addLinkedPosition(this.getFactory().getRewrite().track((ASTNode)simpleDataType), false, "RADIO_VALUE_TYPE");
            links.addLinkedPosition(this.getFactory().getRewrite().track((ASTNode)initValue), true, "RADIO_VALUE");
        }
    }
}

