/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.wellform;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.scout.sdk.core.s.structured.Wellformer;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.CachingJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.SourceFormatOperation;
import org.eclipse.text.edits.ReplaceEdit;

public class WellformScoutTypeOperation
implements IOperation {
    private final Set<IType> m_types;
    private final boolean m_recursive;
    private final IJavaEnvironmentProvider m_envProvider;

    public WellformScoutTypeOperation(Set<IType> types, boolean recursive) {
        this.m_types = new HashSet<IType>(types);
        this.m_recursive = recursive;
        this.m_envProvider = new CachingJavaEnvironmentProvider();
    }

    @Override
    public String getOperationName() {
        StringBuilder builder = new StringBuilder();
        builder.append("Wellform ");
        if (this.m_types.size() > 0) {
            int i = 0;
            builder.append('\'');
            for (IType t : this.m_types) {
                builder.append(t.getElementName());
                if (i < 2) {
                    builder.append(", ");
                } else if (i == 2) break;
                ++i;
            }
            builder.append('\'');
        }
        builder.append("...");
        return builder.toString();
    }

    @Override
    public void validate() {
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        monitor.beginTask("Wellform classes...", this.m_types.size());
        for (IType t : this.m_types) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.subTask("Wellform '" + t.getElementName() + "'.");
            this.wellformType(t, workingCopyManager);
            monitor.worked(1);
        }
        monitor.done();
    }

    protected void wellformType(IType type, IWorkingCopyManager workingCopyManager) throws CoreException {
        ISourceRange typeRange = type.getSourceRange();
        if (!SourceRange.isAvailable((ISourceRange)typeRange)) {
            return;
        }
        ICompilationUnit icu = type.getCompilationUnit();
        String lineSeparator = icu.findRecommendedLineSeparator();
        Wellformer w = new Wellformer(lineSeparator, this.isRecursive());
        StringBuilder sourceBuilder = new StringBuilder(typeRange.getLength() * 2);
        boolean success = w.buildSource(this.m_envProvider.jdtTypeToScoutType(type), sourceBuilder);
        if (success) {
            try {
                workingCopyManager.register(icu, null);
                ReplaceEdit edit = new ReplaceEdit(typeRange.getOffset(), typeRange.getLength(), sourceBuilder.toString());
                IBuffer icuBuffer = icu.getBuffer();
                Document sourceDoc = new Document(icuBuffer.getContents());
                edit.apply((IDocument)sourceDoc);
                SourceFormatOperation op = new SourceFormatOperation(type.getJavaProject(), sourceDoc);
                op.run(null, workingCopyManager);
                icuBuffer.setContents(sourceDoc.get());
            }
            catch (Exception e) {
                SdkLog.warning((String)"Could not wellform type '{}'.", (Object[])new Object[]{type.getFullyQualifiedName(), e});
            }
        } else {
            SdkLog.warning((String)"Unable to get source of type '{}'. Skipping wellform for this type.", (Object[])new Object[]{type.getFullyQualifiedName()});
        }
    }

    public boolean isRecursive() {
        return this.m_recursive;
    }
}

