/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.testers;

import java.util.Iterator;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility.HideDDiagramElementAction;

public class CanHideElementTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = false;
        if ("canHideElement".equals(property)) {
            if (receiver instanceof IStructuredSelection) {
                result = this.testStructuredSelection((IStructuredSelection)receiver);
            } else if (receiver instanceof IDiagramElementEditPart) {
                result = this.testDiagramElementEditPart((IDiagramElementEditPart)receiver);
            }
        }
        return result;
    }

    private boolean testDiagramElementEditPart(IDiagramElementEditPart selectedElement) {
        boolean result = true;
        DDiagramElement diagramElement = selectedElement.resolveDiagramElement();
        if (diagramElement == null) {
            result = false;
        } else {
            DDiagram parentDiagram = diagramElement.getParentDiagram();
            result = parentDiagram != null ? HideDDiagramElementAction.allowsHideReveal(parentDiagram).apply((Object)diagramElement) : false;
            result = result && !parentDiagram.isIsInShowingMode();
        }
        return result;
    }

    private boolean testStructuredSelection(IStructuredSelection selectedElements) {
        boolean result = true;
        Iterator iterator = selectedElements.iterator();
        if (!iterator.hasNext()) {
            result = false;
        }
        while (iterator.hasNext()) {
            Object next = iterator.next();
            result = next instanceof IDiagramElementEditPart ? result && this.testDiagramElementEditPart((IDiagramElementEditPart)next) : false;
        }
        return result;
    }
}

