/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.processes;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;

public class ProcessWaiter
extends Thread {
    private Process process;
    private ICallback callback;
    private boolean finished;
    private int exitCode;

    public ProcessWaiter(Process process) {
        this(process, null);
    }

    public ProcessWaiter(Process process, ICallback callback) {
        Assert.isNotNull((Object)process);
        this.process = process;
        this.callback = callback;
        this.finished = false;
        this.exitCode = -1;
    }

    @Override
    public void run() {
        try {
            this.exitCode = this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {}
        this.finished = true;
        if (this.callback != null) {
            this.callback.setResult(this.exitCode);
            this.callback.done(this, Status.OK_STATUS);
        }
    }

    public final boolean isFinished() {
        return this.finished;
    }

    public final int getExitCode() {
        return this.exitCode;
    }
}

